/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 11/10/2023
 */
 
#include "openssl_.h"

class PyJrpUI:public openssl::jrp::pkg::JrpUI
{
   public:
        PyJrpUI(event::Manager *manager,openssl::pkg::Ctx_Peer_Tls *ctx,vmp::utils::Logger *logger=0);
        ~PyJrpUI();

        pylib::PyCall pysessionclientcb_;
        pylib::PyCall pysessionservercb_;
        pylib::PyCall pycloseclientcb_;
        pylib::PyCall pycloselistencb_;
        pylib::PyCall pycloseservercb_;
        
        pylib::PyCall pyrequestcb_;
        pylib::PyCall pykillcb_;
        pylib::PyCall pyresponsecb_;
        pylib::PyCall pyclosecb_;
};

PyJrpUI::PyJrpUI(event::Manager *manager,openssl::pkg::Ctx_Peer_Tls *ctx,vmp::utils::Logger *logger):openssl::jrp::pkg::JrpUI(manager,ctx,logger)
{
}

PyJrpUI::~PyJrpUI()
{
}

struct Jrp_JrpUI_Constructor:public pylib::Constructor<PyJrpUI>
{
    PyJrpUI *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 2)
         {
             event::Manager *manager=args.get<event::Manager *>(0);
             openssl::pkg::Ctx_Peer_Tls *ctx=args.get<openssl::pkg::Ctx_Peer_Tls *>(1);
             return new PyJrpUI(manager,ctx);
         }
         else if(args.size() == 3)
         {
             event::Manager *manager=args.get<event::Manager *>(0);
             openssl::pkg::Ctx_Peer_Tls *ctx=args.get<openssl::pkg::Ctx_Peer_Tls *>(1);
             vmp::utils::Logger *logger=0;
             if(!args.is_none(2))
                 logger=args.get<vmp::utils::Logger *>(2);
             return new PyJrpUI(manager,ctx,logger);
         }
         return 0;
    }
};

void jrp_sessionclientcb(event::Cell *cell)
{
    PyJrpUI *jrpui=cell->ui<PyJrpUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    jrpui->pysessionclientcb_.call(cargs);
}

void jrp_sessionservercb(event::Cell *cell)
{
    PyJrpUI *jrpui=cell->ui<PyJrpUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    jrpui->pysessionservercb_.call(cargs);
}

void jrp_closeclientcb(event::Cell *cell)
{
    PyJrpUI *jrpui=cell->ui<PyJrpUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    jrpui->pycloseclientcb_.call(cargs);
}

void jrp_closelistencb(event::Cell *cell)
{
    PyJrpUI *jrpui=cell->ui<PyJrpUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    jrpui->pycloselistencb_.call(cargs);
}

void jrp_closeservercb(event::Cell *cell)
{
    PyJrpUI *jrpui=cell->ui<PyJrpUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    jrpui->pycloseservercb_.call(cargs);
}

struct stub_Jrp_JrpUI_set_connect_event:public pylib::Member_def<PyJrpUI>
{
    pylib::Objref *def(PyJrpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 5)
        {
            event::EVTCB sessionclientcb;
            event::EVTCB sessionservercb;
            event::EVTCB closeclientcb;
            event::EVTCB closelistencb;
            event::EVTCB closeservercb;

            args.get_callable(0,instance->pysessionclientcb_);
            if(pylib::is_none(instance->pysessionclientcb_.ref()))
               sessionclientcb=0;
            else 
               sessionclientcb=jrp_sessionclientcb;
            args.get_callable(1,instance->pysessionservercb_);
            if(pylib::is_none(instance->pysessionservercb_.ref()))
               sessionservercb=0;
            else 
               sessionservercb=jrp_sessionservercb;
            args.get_callable(2,instance->pycloseclientcb_);
            if(pylib::is_none(instance->pycloseclientcb_.ref()))
               closeclientcb=0;
            else 
               closeclientcb=jrp_closeclientcb;
            args.get_callable(3,instance->pycloselistencb_);
            if(pylib::is_none(instance->pycloselistencb_.ref()))
               closelistencb=0;
            else 
               closelistencb=jrp_closelistencb;
            args.get_callable(4,instance->pycloseservercb_);
            if(pylib::is_none(instance->pycloseservercb_.ref()))
               closeservercb=0;
            else 
               closeservercb=jrp_closeservercb;
            instance->set_connect_event(sessionclientcb,sessionservercb,closeclientcb,closelistencb,closeservercb);
            return pylib::retnone();                      
        }
        return 0;
    }
};

void jrp_requestcb(event::Cell *cell,json::jrp::JrpReq_I *jreq)
{
    PyJrpUI *jrpui=cell->ui<PyJrpUI>();
    pylib::CArgs cargs(2);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<openssl::jrp::pkg::JrpReq *>((openssl::jrp::pkg::JrpReq *)jreq,false);
    jrpui->pyrequestcb_.call(cargs);
}

void jrp_killcb(event::Cell *cell,json::jrp::JrpReq_I *jreq)
{
    PyJrpUI *jrpui=cell->ui<PyJrpUI>();
    pylib::CArgs cargs(2);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<openssl::jrp::pkg::JrpReq *>((openssl::jrp::pkg::JrpReq *)jreq,false);
    jrpui->pykillcb_.call(cargs);
}

void jrp_responsecb(event::Cell *cell,json::jrp::JrpReq_I *jreq,json::JsonObj *jdata)
{
    PyJrpUI *jrpui=cell->ui<PyJrpUI>();
    pylib::CArgs cargs(3);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<openssl::jrp::pkg::JrpReq *>((openssl::jrp::pkg::JrpReq *)jreq,false);
    cargs.add<json::JsonObj *>(jdata,false);
    jrpui->pyresponsecb_.call(cargs);
}

void jrp_closecb(event::Cell *cell,json::jrp::JrpReq_I *jreq)
{
    PyJrpUI *jrpui=cell->ui<PyJrpUI>();
    pylib::CArgs cargs(2);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<openssl::jrp::pkg::JrpReq *>((openssl::jrp::pkg::JrpReq *)jreq,false);
    jrpui->pyclosecb_.call(cargs);
}

struct stub_Jrp_JrpUI_set_request_event:public pylib::Member_def<PyJrpUI>
{
    pylib::Objref *def(PyJrpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 4)
        {
            json::jrp::JRPCB requestcb;
            json::jrp::JRPCB killcb;
            json::jrp::JRPRESPCB responsecb;
            json::jrp::JRPCB closecb;
            
            args.get_callable(0,instance->pyrequestcb_);
            if(pylib::is_none(instance->pyrequestcb_.ref()))
               requestcb=0;
            else 
               requestcb=jrp_requestcb;
            args.get_callable(1,instance->pykillcb_);
            if(pylib::is_none(instance->pykillcb_.ref()))
               killcb=0;
            else 
               killcb=jrp_killcb;
            args.get_callable(2,instance->pyresponsecb_);
            if(pylib::is_none(instance->pyresponsecb_.ref()))
               responsecb=0;
            else 
               responsecb=jrp_responsecb;
            args.get_callable(3,instance->pyclosecb_);
            if(pylib::is_none(instance->pyclosecb_.ref()))
               closecb=0;
            else 
               closecb=jrp_closecb;
            instance->set_request_event(requestcb,killcb,responsecb,closecb);
            return pylib::retnone();                      
        }
        return 0;
    }
};

struct stub_Jrp_JrpUI_search_peer:public pylib::Member_def<PyJrpUI>
{
    pylib::Objref *def(PyJrpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
            return pylib::Converter<vmp::vector<vmp::str> >(instance->search_peer());
        else if(args.size() == 1)
        {
            vmp::str input=args.get<vmp::str>(0);
            return pylib::Converter<vmp::vector<vmp::str> >(instance->search_peer(input));
        }
        return 0;
    }
};

struct stub_Jrp_JrpUI_search_input:public pylib::Member_def<PyJrpUI>
{
    pylib::Objref *def(PyJrpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str fingerprint=args.get<vmp::str>(0);
            return pylib::Converter<vmp::vector<vmp::str> >(instance->search_input(fingerprint));
        }
        else if(args.size() == 2)
        {
            vmp::str fingerprint=args.get<vmp::str>(0);
            vmp::str output=args.get<vmp::str>(1);
            return pylib::Converter<vmp::vector<vmp::str> >(instance->search_input(fingerprint,output));
        }
        return 0;
    }
};

struct stub_Jrp_JrpReq_close:public pylib::Member_def<openssl::jrp::pkg::JrpReq>
{
    pylib::Objref *def(openssl::jrp::pkg::JrpReq *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp_int status=args.get<vmp_int>(0);
            instance->close(status);
            return pylib::retnone(); 
        }
        else if(args.size() == 2)
        {
            vmp_int status=args.get<vmp_int>(0);
            vmp::str msg=args.get<vmp::str>(1);
            instance->close(status,msg);
            return pylib::retnone(); 
        }
        return 0;
    }
};

void openssl_jrp(pylib::Module module)
{
    pylib::Module jrp=module.add_submodule("jrp");
    
    pylib::Class<openssl::jrp::pkg::JrpReq> jrpreq=jrp.class_no_constructor<openssl::jrp::pkg::JrpReq>("JrpReq");
    jrpreq.def_("type",&openssl::jrp::pkg::JrpReq::type);
    jrpreq.def_("rid",&openssl::jrp::pkg::JrpReq::rid);
    jrpreq.def_("key",&openssl::jrp::pkg::JrpReq::key);
    jrpreq.def_("json_jdata",&openssl::jrp::pkg::JrpReq::json_jdata,false);
    jrpreq.def_("jdata",&openssl::jrp::pkg::JrpReq::jdata,false);
    jrpreq.def_("status",&openssl::jrp::pkg::JrpReq::status);
    jrpreq.def_("msg",&openssl::jrp::pkg::JrpReq::msg);
    jrpreq.def_("alloc",&openssl::jrp::pkg::JrpReq::alloc);
    jrpreq.def_("release",&openssl::jrp::pkg::JrpReq::release);
    jrpreq.def_("response",&openssl::jrp::pkg::JrpReq::response);
    jrpreq.def_("kill",&openssl::jrp::pkg::JrpReq::kill);
    jrpreq.def_with_stub("close",stub_Jrp_JrpReq_close());
    
    pylib::Class<PyJrpUI> jrpui=jrp.class_with_constructor<PyJrpUI>("JrpUI",Jrp_JrpUI_Constructor());
    jrpui.def_("set_timers",&openssl::jrp::pkg::JrpUI::set_timers);
    jrpui.def_("set_limits",&openssl::jrp::pkg::JrpUI::set_limits);
    jrpui.def_with_stub("set_connect_event",stub_Jrp_JrpUI_set_connect_event());
    jrpui.def_with_stub("set_request_event",stub_Jrp_JrpUI_set_request_event());
    jrpui.def_("new_client",&openssl::jrp::pkg::JrpUI::new_client,false);
    jrpui.def_("new_listen",&openssl::jrp::pkg::JrpUI::new_listen,false);
    jrpui.def_("connection_type",&openssl::jrp::pkg::JrpUI::connection_type);
    jrpui.def_("ctx",&openssl::jrp::pkg::JrpUI::ctx,false);
    jrpui.def_("logger",&openssl::jrp::pkg::JrpUI::logger,false);
    jrpui.def_("peer_subject",&openssl::jrp::pkg::JrpUI::peer_subject);
    jrpui.def_("peer_permits",&openssl::jrp::pkg::JrpUI::peer_permits);
    jrpui.def_("add_reqdata",&openssl::jrp::pkg::JrpUI::add_reqdata);
    jrpui.def_with_stub("search_peer",stub_Jrp_JrpUI_search_peer());
    jrpui.def_with_stub("search_input",stub_Jrp_JrpUI_search_input());
    jrpui.def_("search_outputs",&openssl::jrp::pkg::JrpUI::search_outputs);
    jrpui.def_("exitcode",&openssl::jrp::pkg::JrpUI::exitcode);
    jrpui.def_("isremoteabort",&openssl::jrp::pkg::JrpUI::isremoteabort);
    jrpui.def_("request",&openssl::jrp::pkg::JrpUI::request,false);
}

