/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 12/08/2023
*/

#include "db_.h"

struct Sqlite_stub_Constructor:public pylib::Constructor<db::pkg::Sqlite>
{
    db::pkg::Sqlite *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str db=args.get<vmp::str>(0);
            return new db::pkg::Sqlite(db); 
        }
        return 0;
    }
};

struct stub_sqlite_query:public pylib::Member_def<db::pkg::Sqlite>
{
    pylib::Objref *def(db::pkg::Sqlite *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str sql=args.get<vmp::str>(0);
            instance->query(sql);
            return pylib::retnone();    
        }
        else if(args.size() == 2)
        {
            vmp::str sql=args.get<vmp::str>(0);
            if(args.is_none(1))
                instance->query(sql);
            else
            {
                db::pkg::Result *result=args.get<db::pkg::Result *>(1);
                instance->query(sql,result);
            }
            return pylib::retnone();
        }
        return 0;
    }
};

void app_db_init(pylib::Module module)
{
    pylib::Class<db::pkg::Result> result=module.class_<db::pkg::Result>("Result");
    result.def_("reset",&db::pkg::Result::reset);
    result.def_("size_fields",&db::pkg::Result::size_fields);
    result.def_("get_field",&db::pkg::Result::get_field);
    result.def_("size",&db::pkg::Result::size);
    result.def_("get_row",&db::pkg::Result::get_row);
    result.def_("get_column",&db::pkg::Result::get_column);
    result.def_("get_column_name",&db::pkg::Result::get_column_name);
    result.def_("get_value",&db::pkg::Result::get_value);
    result.def_("get_value_name",&db::pkg::Result::get_value_name);
    
    pylib::Class<db::pkg::Sqlite> sqlite=module.class_with_constructor<db::pkg::Sqlite>("Sqlite",Sqlite_stub_Constructor());
    sqlite.def_("filedb",&db::pkg::Sqlite::filedb);
    sqlite.def_with_stub("query",stub_sqlite_query());
    sqlite.def_("verify",&db::pkg::Sqlite::verify);
}

VAMPIRIA_PYLIB_INIT(vmp_db0_);
 
void vampiria_pylib_init_module(pylib::Module init_module)
{
    app_db_init(init_module);
}
