#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 19/06/2020

import vmp

##data utils

data_static_=''
data_var_='$'

def new_data_type(value):
  if len(value) == 0:
    vmp.except_s('new_data_type : empty value')
  elif value[0] == data_var_:
    if len(value) < 2:
      vmp.except_s('new_data_type : empty var')
    else:
      return (data_var_,value[1:])
  elif len(value) >= 2 and value[0] == '\\' and (value[1] == gui_data_var_):
    return (data_static_,value[1:])
  return (data_static_,value)

def data_isvar(value):
  if value[0] == data_var_:
    return True
  return False

def data_isstatic(value):
  if value[0] == data_static_:
    return True
  return False

def data_value(value):
  return value[1]

def data_dict_value(value,dvar):
  if data_isvar(value):
    v=data_value(value)
    if v in dvar:
      return dvar[v]
  return ()

##pycode

PyObjTable={}

class Front:
  def __init__(self):
   self.args=['var','string','index']

  def exec_code(self,args):
    ret=[]
    space=''
    for i in range(0,args[2]):
      space=space + ' '
    for arg in args[0]:
      ret.append("{0}{1}{2}".format(args[1],space,arg))
    return ret 

class Tail:
  def __init__(self):
    self.args=['var','string','index']

  def exec_code(self,args):
    ret=[]
    space=''
    for i in range(0,args[2]):
      space=space + ' '
    for arg in args[0]:
      ret.append("{0}{1}{2}".format(arg,space,args[1]))
    return ret

class Indexer:
  def __init__(self):
    self.args=['var','index']

  def exec_code(self,args):
    ret=[]
    var=args[0]
    index=args[1]
    if index < len(var):
      ret.append(var[index])
    return ret

class NotIndexer:
  def __init__(self):
    self.args=['var','index']

  def exec_code(self,args):
    ret=[]
    var=args[0]
    index=args[1]
    for i in range(0,len(var)):
      if i != index:
        ret.append(var[i])
    return ret

class Column:
  def __init__(self):
    self.args=['var','index']

  def exec_code(self,args):
    ret=[]
    var=args[0]
    index=args[1]
    for v in var:
      split=vmp.unicode.str_split(v,' ')
      if index < len(split):
        ret.append(split[index])
      else:
        ret.append('')
    return ret 

class NotColumn:
  def __init__(self):
    self.args=['var','index']

  def exec_code(self,args):
    ret=[]
    var=args[0]
    index=args[1]
    for v in var:
      split=vmp.unicode.str_split(v,' ')
      row=""
      for i in range(0,len(split)):
        if i != index:
          row="{0} {1}".format(row,split[i])
      ret.append(row)
    return ret

class Join:
  def __init__(self):
    self.args=['var','var','index']

  def exec_code(self,args):
    ret=[]
    space=''
    for i in range(0,args[2]):
      space=space + ' '
    var0=args[0]
    var1=args[1]
    l0=len(var0)
    l1=len(var1)
    i=0
    while i < l0 and i < l1:
      ret.append("{0}{1}{2}".format(var0[i],space,var1[i]))
      i=i+1
    if l0 < l1:
      while i < l1:
        ret.append("{0}".format(var1[i]))
        i=i+1
    elif l1 < l0:
      while i < l0:
        ret.append("{0}".format(var0[i]))
        i=i+1
    return ret

PyObjTable["front"]=Front()
PyObjTable["tail"]=Tail()
PyObjTable["indexer"]=Indexer()
PyObjTable["notindexer"]=NotIndexer()
PyObjTable["column"]=Column()
PyObjTable["notcolumn"]=NotColumn()
PyObjTable["join"]=Join()


