/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 17/01/2023
 */

#include "rawnet3/rawnet3.h"

namespace vampiria { namespace rawnet { namespace pkg {

RawNetUI::RawNetUI(event::Manager *manager):event::UI(manager)
{
    set_event(0,0);
}
        
RawNetUI::~RawNetUI()
{
}

vmp::str RawNetUI::identity(event::Cell *cell)
{
    vmp::str ret;
    rawnet::pkg::EventRawNet *revent=cell->event<rawnet::pkg::EventRawNet>();
    vmp::unicode::str_write(&ret,"Rawnet event [interface=%s] [linktype=%s] [mode=%s] ",revent->evt_rawnet_iface().c_str(),revent->evt_rawnet_linktype_str().c_str(),revent->evt_rawnet_mode().c_str());
    return ret;
}
       
void RawNetUI::close_event(event::Cell *cell)
{
    rawnet::pkg::EventRawNet *revent=cell->event<rawnet::pkg::EventRawNet>();
    revent->evt_rawnet_close();
}
       
void RawNetUI::free_ref(event::Cell *cell)
{
    rawnet::pkg::EventRawNet *revent=cell->event<rawnet::pkg::EventRawNet>();
    revent->evt_rawnet_free();
    rref_.free(revent);
}

void RawNetUI::set_event(net::EVTCBRECV recv,event::EVTCB cevent)
{
    recv_=recv;
    cevent_=cevent;
}

event::Cell *RawNetUI::new_rawnet(vmp::str ifname,vmp::str filter)
{
    event::Cell *cell=0;
    manager_->lock();
    rawnet::pkg::EventRawNet *revent=rref_.get();
    try
    {
        cell=revent->evt_rawnet_rw_new(this,ifname,filter,recv_,cevent_);
    }
    catch(vmp::exception &x)
    {
        rref_.free(revent);
        manager_->unlock();
        vmp::except_s(x.what()); 
    }
    manager_->unlock();
    return cell;
}

event::Cell *RawNetUI::new_rawnet_w(vmp::str ifname)
{
    event::Cell *cell=0;
    manager_->lock();
    rawnet::pkg::EventRawNet *revent=rref_.get();
    try
    {
        cell=revent->evt_rawnet_w_new(this,ifname,cevent_);
    }
    catch(vmp::exception &x)
    {
        rref_.free(revent);
        manager_->unlock();
        vmp::except_s(x.what()); 
    }
    manager_->unlock();
    return cell;
}

void RawNetUI::start_read(event::Cell *cell)
{
    rawnet::pkg::EventRawNet *revent=cell->event<rawnet::pkg::EventRawNet>();
    event::Manager *manager=cell->get_manager();
    manager->lock();
    revent->evt_rawnet_loop();
    manager->unlock();        
}

void RawNetUI::inject(event::Cell *cell,vmp::Buf *buf)
{
    rawnet::pkg::EventRawNet *revent=cell->event<rawnet::pkg::EventRawNet>();
    event::Manager *manager=cell->get_manager();
    manager->lock();
    try
    {
        revent->evt_rawnet_inject(buf);
    }
    catch(vmp::exception &x)
    {
        manager->unlock();
        vmp::except("rawnet::pkg::RawNetUI::inject '%s'",x.what());
    }
    manager->unlock();
}

vmp::str RawNetUI::ifname(event::Cell *cell)
{
    rawnet::pkg::EventRawNet *revent=cell->event<rawnet::pkg::EventRawNet>();
    event::Manager *manager=cell->get_manager();
    manager->lock();
    vmp::str ret=revent->evt_rawnet_iface();
    manager->unlock();
    return ret;    
}

vmp::str RawNetUI::filter(event::Cell *cell)
{
    rawnet::pkg::EventRawNet *revent=cell->event<rawnet::pkg::EventRawNet>();
    event::Manager *manager=cell->get_manager();
    manager->lock();
    vmp::str ret=revent->evt_rawnet_filter();
    manager->unlock();
    return ret; 
}

vmp::str RawNetUI::mode(event::Cell *cell)
{
    rawnet::pkg::EventRawNet *revent=cell->event<rawnet::pkg::EventRawNet>();
    event::Manager *manager=cell->get_manager();
    manager->lock();
    vmp::str ret=revent->evt_rawnet_mode();
    manager->unlock();
    return ret; 
}

vmp_int RawNetUI::linktype(event::Cell *cell)
{
    rawnet::pkg::EventRawNet *revent=cell->event<rawnet::pkg::EventRawNet>();
    event::Manager *manager=cell->get_manager();
    manager->lock();
    vmp_int ret=revent->evt_rawnet_linktype();
    manager->unlock();
    return ret;
}

vmp::str RawNetUI::linktype_str(event::Cell *cell)
{
    rawnet::pkg::EventRawNet *revent=cell->event<rawnet::pkg::EventRawNet>();
    event::Manager *manager=cell->get_manager();
    manager->lock();
    vmp::str ret=revent->evt_rawnet_linktype_str();
    manager->unlock();
    return ret; 
} 

}}}

