/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 10/10/2023
*/

#ifndef VAMPIRIA_OPENSSL_PKG_JRP_JRPEVENT_H

#define VAMPIRIA_OPENSSL_PKG_JRP_JRPEVENT_H 1

namespace vampiria { namespace openssl { namespace jrp { namespace pkg {

//! Used to manage requests
class JrpReq:public json::jrp::JrpReq_I
{
    private:
         //! Virtual class
        vmp::str setkey_impl();

        //! Virtual class
        void send_impl(vmp::Buf *buf);

        //! Virtal class
        void free_impl();
    public:
        //! A Constructor
        JrpReq();
        
        //! A Destructor
        ~JrpReq();
};

//!Class shared by the jrp event(see EventJrp)
class JrpCommon:public openssl::pkg::P2pCommon
{
    public:
        //! A Constructor
        JrpCommon(event::Manager *manager);

        //! A Destructor
        ~JrpCommon();

        vmp::Table<vmp::str,vmp::vector<vmp::str> > reqdata_;/*!< Information table of the types of jdata accepted by requests, exchanged when the session starts*/

        vmp::time::Time ctimeout_;/*!< SSl connection timeout(default 3.0)*/
        vmp::time::Time stimeout_;/*!< Jrp session timeout(default 3.0)*/
        vmp::time::Time timeout_;/*!< Maximum number of seconds a connection does not receive a packet(default 60 s)*/

        vmp_size backlog_;/*!<the maximum length to which the  queue  of pending  connections for each server(default 10)*/
        vmp_size maxssrvpeer_;/*!<Max number request accepted from peer(default 5)*/
        vmp_size maxclientreq_;/*!<Maximum number of requests a peer can send(default 100)*/
        
        vmp::utils::Storage<openssl::jrp::pkg::JrpReq> jreq_;/*!Storage request event*/
        
        event::EVTCB jrp_sessioncb_;/*!<Callback call when a valid connection has estabilized*/
        event::EVTCB jrp_closecb_;/*!<Callback call when a valid connection has estabilized*/
        json::jrp::JRPCB jrp_requestcb_;/*!<Callback call when a request message has been received*/
        json::jrp::JRPCB jrp_killcb_;/*!<Callback call when a kill message has been received*/
        json::jrp::JRPRESPCB jrp_responsecb_;/*!<Callback call when a response message has been received*/
        json::jrp::JRPCB jrp_requestclosecb_;/*!<Callback call when a close message has been received*/
};

//! A json request protocol event 
class EventJrp:public openssl::pkg::EventP2p
{
    private:
        //! Event reset
        void evt_jrp_reset();
    public:
        //! A Constructor
        EventJrp();

        //!A Destructor
        ~EventJrp();

        vmp::Table<vmp_uint,openssl::jrp::pkg::JrpReq *> srvreq_;/*!<Request from peer */
        vmp::Table<vmp_uint,openssl::jrp::pkg::JrpReq *> cltreq_;/*!<Request to peer*/
        vmp_index refrid_;/*!<Internal usage*/
        vmp::Table<vmp::str,vmp::vector<vmp::str> > preqdata_;/*!<Peer information table of the types of jdata accepted by requests, exchanged when the session starts*/
        vmp::time::Time timerecv_;/*!<Time of last received package*/
        vmp_bool remoteabort_;/*!<Remote abort message? internal usage*/
        vmp_int  exitcode_;/*!<Exit code of the event*/
        vmp_bool established_;/*!<Connection is established?*/
        
        //!Create a new event jrp client
        /*!
            @param ui user interface (see Class UI)
            @param server remote server address
            @param ctx peer context
            @param common shared jrp class
            @return the new cell associated with the event or except in case of failure
        */
        event::Cell *evt_jrp_client(event::UI *ui,net::Address *server,openssl::pkg::Ctx_Peer_Tls *ctx,openssl::jrp::pkg::JrpCommon *common);

        //!Create a new event jrp server
        /*!
            @param ui user interface (see Class UI)
            @param local address to listen server connection
            @param ctx peer context
            @param common shared jrp class
            @return the new cell associated with the event or except in case of failure
        */
        event::Cell *evt_jrp_server(event::UI *ui,net::Address *local,openssl::pkg::Ctx_Peer_Tls *ctx,openssl::jrp::pkg::JrpCommon *common);

        //!Send a jrp request
        /*!
            @param jdata json input data
            @return a structure of the request jrp or except in case of failure("Overflow request" if the number of requests exceeds the maximum number) 
        */
        openssl::jrp::pkg::JrpReq *evt_jrp_request(json::JsonObj *jdata);
        
        //! Close event
        void evt_jrp_close();

        //! Free event
        void evt_jrp_free();
};

}}}}

#endif

