/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 10/10/2023
*/

#include "openssl3/openssl3.h"

namespace vampiria { namespace openssl { namespace jrp { namespace pkg {

JrpReq::JrpReq():json::jrp::JrpReq_I()
{
}

JrpReq::~JrpReq()
{
}

vmp::str JrpReq::setkey_impl()
{
    vmp::str ret;
    openssl::jrp::pkg::EventJrp *jrp=cell_->event<openssl::jrp::pkg::EventJrp>();
    vmp::unicode::str_write(&ret,"p2p/%s/%u",jrp->peer_.fingerprint().c_str(),rid_);
    return ret;
}

void JrpReq::send_impl(vmp::Buf *buf)
{
    openssl::jrp::pkg::EventJrp *jrp=cell_->event<openssl::jrp::pkg::EventJrp>();
    jrp->evt_ssl_send(buf);
}

void JrpReq::free_impl()
{
    openssl::jrp::pkg::EventJrp *jrp=cell_->event<openssl::jrp::pkg::EventJrp>();
    openssl::jrp::pkg::JrpCommon *common=(openssl::jrp::pkg::JrpCommon *)jrp->common_;
    common->jreq_.free(this);
}

JrpCommon::JrpCommon(event::Manager *manager):openssl::pkg::P2pCommon()
{
    p2ptimer_init(manager,jrp_pingcb);
    reqdata_.clear();
    ctimeout_=3.0;
    stimeout_=3.0;
    timeout_=60;
    backlog_=10;
    maxssrvpeer_=5;
    maxclientreq_=100;
    session_cb_=openssl::jrp::pkg::jrp_sessioncb;
    recv_cb_=openssl::jrp::pkg::jrp_initcb;
    close_cb_=openssl::jrp::pkg::jrp_closecb;
    jrp_sessioncb_=event::empty_ev;
    jrp_closecb_=event::empty_ev;
    jrp_requestcb_=json::jrp::empty_jrpcb;
    jrp_killcb_=json::jrp::empty_jrpcb;
    jrp_responsecb_=json::jrp::empty_jrprespcb;
    jrp_requestclosecb_=json::jrp::empty_jrpcb;
}

JrpCommon::~JrpCommon()
{
}

EventJrp::EventJrp():EventP2p()
{
    evt_jrp_reset();
}

EventJrp::~EventJrp()
{
}

void EventJrp::evt_jrp_reset()
{
    refrid_=0;
    preqdata_.clear();
    timerecv_=0;
    remoteabort_=false;
    exitcode_=json::jrp::status_ok;
    established_=false;
}

event::Cell *EventJrp::evt_jrp_client(event::UI *ui,net::Address *server,openssl::pkg::Ctx_Peer_Tls *ctx,openssl::jrp::pkg::JrpCommon *common)
{
    vmp::except_check_pointer((void *)common,"openssl::pkg::EventJrp::evt_jrp_client(common=null)");
    return evt_p2p_client(ui,server,ctx,(openssl::pkg::P2pCommon *)common,common->ctimeout_);
}

event::Cell *EventJrp::evt_jrp_server(event::UI *ui,net::Address *local,openssl::pkg::Ctx_Peer_Tls *ctx,openssl::jrp::pkg::JrpCommon *common)
{
    vmp::except_check_pointer((void *)common,"openssl::pkg::EventJrp::evt_jrp_server(common=null)");
    return evt_p2p_server(ui,local,common->backlog_,ctx,(openssl::pkg::P2pCommon *)common,common->ctimeout_);
}

openssl::jrp::pkg::JrpReq *EventJrp::evt_jrp_request(json::JsonObj *jdata)
{
    vmp::Buf buf;
    openssl::jrp::pkg::JrpCommon *common=(openssl::jrp::pkg::JrpCommon *)common_;
    openssl::jrp::pkg::JrpReq *ret;
    vmp_index count; 
    while(cltreq_.search(refrid_,&ret))
    {
        count++;
        refrid_++;
        if(count == common->maxclientreq_)
            vmp::except_s("Overflow request");
        if(refrid_ == common->maxclientreq_)
            refrid_=0;
    }
    openssl::jrp::pkg::JrpReq *req=common->jreq_.get();
    try
    {
        json::jrp::request(&buf,refrid_,jdata);
        evt_ssl_send(&buf);
        req->set_request(refrid_,jdata,cell_);
        cltreq_.insert(refrid_,req);
        req->alloc_internal();
        refrid_++;
        if(refrid_ == common->maxclientreq_)
            refrid_=0;
    }
    catch(vmp::exception &x)
    {
        req->release_internal();
        vmp::except_s(x.what());
    }
    return req;
}

void EventJrp::evt_jrp_close()
{
    evt_p2p_close();
}

void EventJrp::evt_jrp_free()
{
    evt_jrp_reset();
    evt_p2p_free();
}

}}}}

