/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 02/07/2023
 */

#include "openssl3/openssl3.h"

namespace vampiria { namespace openssl { namespace pkg {

vmp::str md5(vmp::str istr,vmp::str delimiter)
{
    return openssl::pkg::evp_digest(istr,delimiter,EVP_md5());
}

vmp::str sha1(vmp::str istr,vmp::str delimiter)
{
    return openssl::pkg::evp_digest(istr,delimiter,EVP_sha1());
}

vmp::str sha224(vmp::str istr,vmp::str delimiter)
{
    return openssl::pkg::evp_digest(istr,delimiter,EVP_sha224());
}
   
vmp::str sha256(vmp::str istr,vmp::str delimiter)
{
    return openssl::pkg::evp_digest(istr,delimiter,EVP_sha256());
}

vmp::str sha384(vmp::str istr,vmp::str delimiter)
{
    return openssl::pkg::evp_digest(istr,delimiter,EVP_sha384());
}

vmp::str sha512(vmp::str istr,vmp::str delimiter)
{
    return openssl::pkg::evp_digest(istr,delimiter,EVP_sha512());
}

}}}

