/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 30/04/2023
 */
 
#ifndef VAMPIRIA_OPENSSL_PKG_CTX_HTTPS_H

#define VAMPIRIA_OPENSSL_PKG_CTX_HTTPS_H 1

namespace vampiria { namespace openssl { namespace pkg {

//!Builds a simple server tls context generic
class Ctx_Https_Tls:public openssl::pkg::Ctx_I
{
    private:
        vmp::str dircert_;/*!<Directory files*/
        vmp::str pkey_;/*!<Private key pem file*/
        vmp::str x509_;/*!<X509 pem file*/
       
        vmp_uint days_;/*!<days of validity of the associated certificate*/
        vmp::str subject_;/*!< subject field*/

        //! Virtual function
        SSL_CTX *init();
    public:
        //! A costructor
        /*!
            @param dircert directory files
            @param subject subject associated(in x509 mode)
            @param days validity certified
        */
        Ctx_Https_Tls(vmp::str dircert,vmp::str subject,vmp_uint days=365000);
       
        //! A destructor
        ~Ctx_Https_Tls();
       
        //! Gets certificate associated with the context
        /*!
           @param x509 certificate output
           @return void or except in case failure
        */
        void get_x509(openssl::pkg::X509_Wrap *x509);
};

}}}

#endif

