/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 30/04/2023
 */
 
#include "openssl3/openssl3.h"

namespace vampiria { namespace openssl { namespace pkg {

Ctx_Https_Tls::Ctx_Https_Tls(vmp::str dircert,vmp::str subject,vmp_uint days):Ctx_I()
{
    dircert_=dircert;
    pkey_=vmp::fs::union_path(dircert_,openssl::pkg::pkeypem_);
    x509_=vmp::fs::union_path(dircert_,openssl::pkg::x509pem_);
    subject_=subject;
    days_=days;
    build_ctx();
}

Ctx_Https_Tls::~Ctx_Https_Tls()
{
    dircert_="";
    pkey_="";
    x509_="";
    subject_="";
}

SSL_CTX *Ctx_Https_Tls::init()
{
    vmp::str command;
    vmp_bool cert_create=false;
    try
    {
        if(!vmp::fs::isdir(dircert_))
            vmp::fs::mkdir_wrap(dircert_,0700);
        if(!vmp::fs::isrfile(pkey_))
            cert_create=true;
        if(!vmp::fs::isrfile(x509_))
            cert_create=true;
        else
        {
            openssl::pkg::X509_Wrap x509;
            try
            {
                x509.set_from_file(x509_);
                if(x509.subject() != subject_)
                   cert_create=true; 
            }
            catch(vmp::exception &x)
            {
                cert_create=true;
            }
        }
        if(cert_create)
        {
            vmp::unicode::str_write(&command,"openssl req -nodes -x509 -sha256  -days %u -subj %s -newkey rsa:2048 -keyout %s -out %s",days_,subject_.c_str(),pkey_.c_str(),x509_.c_str());
            vmp::system_wrap(command);
        }
        if(!vmp::fs::isrfile(x509_))
            vmp::except_s("failed create x509 certificatied");
    }
    catch(vmp::exception &x)
    {
        try
        {
            vmp::fs::rmdir_wrap(dircert_);
        }
        catch(vmp::exception &x)
        {
        }
        vmp::except("openssl::pkg::Https_Tls::init() error create credentials '%s'",x.what());
        return 0;
    }
    SSL_CTX *ctx=SSL_CTX_new(TLS_server_method());
    if((SSL_CTX_use_PrivateKey_file(ctx,pkey_.c_str(),SSL_FILETYPE_PEM) <= 0) || (SSL_CTX_use_certificate_file(ctx,x509_.c_str(),SSL_FILETYPE_PEM) <= 0) || !SSL_CTX_check_private_key(ctx))
    {    
        SSL_CTX_free(ctx);
        vmp::except("openssl::pkg::Ctx_Https_Tls::init() error '%s'",openssl::pkg::err_string().c_str());
        return 0;
    }
#if ! defined(LIBRESSL_VERSION_NUMBER)
    SSL_CTX_set_options(ctx,SSL_OP_SINGLE_ECDH_USE);
#endif

#if ! defined(OPENSSL_IS_BORINGSSL)
    SSL_CTX_set_ecdh_auto(ctx, 1);
#endif
    SSL_CTX_set_verify(ctx,SSL_VERIFY_NONE,0);
    SSL_CTX_set_mode(ctx,SSL_MODE_ENABLE_PARTIAL_WRITE);
    SSL_CTX_set_mode(ctx,SSL_MODE_RELEASE_BUFFERS);
    SSL_CTX_set_mode(ctx,SSL_OP_CIPHER_SERVER_PREFERENCE);
    SSL_CTX_set_session_cache_mode(ctx,SSL_SESS_CACHE_OFF);
#if ! defined(LIBRESSL_VERSION_NUMBER)
    SSL_CTX_set_options(ctx, SSL_OP_NO_TICKET);
#endif

#if ! defined(LIBRESSL_VERSION_NUMBER) && ! defined(OPENSSL_IS_BORINGSSL)
    if (SSL_CTX_set_num_tickets(ctx, 0) == 0) 
        vmp::except("openssl::pkg::Ctx_Https_Tls::init() Failed to set number of ticket to zero");
#endif

#if ! defined(LIBRESSL_VERSION_NUMBER)
    SSL_CTX_set_options(ctx,SSL_OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION);
#endif
    return ctx;
}

void Ctx_Https_Tls::get_x509(openssl::pkg::X509_Wrap *x509)
{
    vmp::except_check_pointer((void *) x509,"openssl::pkg::Ctx_Base_Tls_Server::get_x509() null input");
    x509->set(SSL_CTX_get0_certificate(ctx_.ctx_));
}

}}}

