/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 25/03/2023
 */

#ifndef VAMPIRIA_VMP_ENV_H

#define VAMPIRIA_VMP_ENV_H 1

namespace vampiria { namespace vmp { namespace env {

//!Return the vampire author string
/*!
    @return author string
*/
vmp::str author();

//!Returns the email string associated with the project
/*!
    @return email string
*/
vmp::str email();

//!Returns the string of the site associated with the project
/*!
    @return webpage string
*/
vmp::str webpage();

//!Returns the project license string
/*!
    @return license string
*/
vmp::str license();

//!Return the vampiria version string
/*!
    @return version string
*/
vmp::str version();

//!Returns the absolute path of a vampiria file or directory contained in vampiria
/*!
    @param subpath path inside vampiria
    @return the string of vampiria path.If an empty string is subpath it returns the root path of vampiria
*/
vmp::str vampiria_path(vmp::str subpath="");

//!Returns the absolute path of a vampiria executable file
/*!
    @param name program name
    @return the absolute path executable if it exists,otherwise throw exception
*/
vmp::str vampiria_bin(vmp::str name);

//!Returns the absolute path of a vampire library external to the framework
/*!
    @param name lib name library name without the extension .so
    @return the absolute path library if it exists,otherwise throw exception
*/
vmp::str vampiria_lib(vmp::str name);

//!Returns the absolute path of a cached subdirectory
/*!
   @param subpath path inside in cache
   @return the string of cache path.If an empty string is subpath it returns the cache path
*/
vmp::str vampiria_cache(vmp::str subpath="");

//!Returns the absolute path of a home subdirectory
/*!
    @param subpath path inside in home
    @return the string of home path.If an empty string is subpath it returns the home path
*/
vmp::str vampiria_home(vmp::str subpath="");

//!Returns the absolute path of the root software directory
/*!
    @return the string path.
*/
vmp::str software_root();
 
//!Returns the absolute path of a software subdirectory
/*!
    @param name software name
    @param subpath path inside in software.
    @return the string path. If an empty string is subpath it returns the software path.If software not found throw exception
*/
vmp::str software_path(vmp::str name,vmp::str subpath="");

//!Check if software is installed in dirpath
/*!
    @param path absolute directory software or module path
    @return true is installed,otherwise false. If path is not found throw exception 
*/
vmp_bool software_isinstalled(vmp::str dirpath);

//!Returns the absolute path of the root module  directory
/*!
    @return the string path.
*/
vmp::str modules_root();

//!Returns the absolute path of a module subdirectory
/*!
    @param name module name
    @param subpath path inside in module.
    @return the string path.If an empty string is subpath it returns the module path.If module not found throw exception
*/
vmp::str module_path(vmp::str name,vmp::str subpath="");

//!Returns the absolute path of a module main directory(Contains files for installing and running the software associated with the module).
/*!
    @param name module name
    @return main path directory.If not found throw exception
*/
vmp::str module_main_path(vmp::str name); 

//!Returns the absolute path of a module xml manifest file.
/*!
    @param name module name
    @return manifest path.If not found throw exception
*/ 
vmp::str module_manifest(vmp::str name);

//!Check if module name is installed
/*!
    @param name module name
    @return true is installed,otherwise false. If module or module main is not found throw exception 
*/
vmp_bool module_isinstalled(vmp::str name);

//!Returns the absolute path of a c++ pkg subdirectory
/*!
    @param name pkg name
    @param subpath path inside in pkg.
    @return the string path.If an empty string is subpath it returns the pkg path.If pkg not found throw exception
*/
vmp::str pkg_path(vmp::str name,vmp::str subpath="");

//!Returns the absolute path of a python pkg subdirectory
/*!
    @param name pkg name
    @param subpath path inside in pkg.
    @return the string path.If an empty string is subpath it returns the pkg path.If pkg not found throw exception
*/
vmp::str vpkg_path(vmp::str name,vmp::str subpath="");

//!Returns the absolute path of a dtd file in framework.
/*!
    @param dtd dtd file name
    @return dtd absolute path. if file not found throw exception
*/
vmp::str frm_dtd(vmp::str dtd);

//!Returns the python executable interpreter used
/*!
    @return python execurtable string( ex /usr/bin/pyrhon)
*/
vmp::str python_exe();

//!Returns the python enviroments vampiria
/*!
    @return enviroments vampiria
*/
vmp::str python_env();

//!Returns the name of the main module where the modules are located in the vampiria python environment
/*!
    @return main module in pyenv
*/
vmp::str python_moduleimp();

//!Returns the python main used in framework
/*!
    @return python main path
*/
vmp::str python_main();

//!Returns the main file of software vampiria written in python
/*!
    @param dirsoftware
    @return main path.if not found throw exception
*/
vmp::str python_software_main(vmp::str dirsoftware);

//!Check if the string in the path is a file used for running python __*__ (example __init __, __ pycache__ etc ..)
/*!
    @param path file path
    @return true if files python, otherwise false
*/
vmp_bool python_files_check(vmp::str path);

//!Returns the header string used for xml files in the framework
/*!
    @return string header
*/
vmp::str xml_hdr();

}}}

#endif


