/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 25/01/2020
 */

#include "pylib.h"

namespace vampiria { namespace pylib {

Module::Module(pylib::Objref *ref,vmp::str name,vmp::str prefix):pylib::Objbase(ref,name,prefix)
{
}

Module::~Module()
{
}

pylib::Module Module::add_submodule(vmp::str name)
{
    pylib::Objref *sub=pylib::pymodule_addsubmodule(ref(),name,fullname());
    return pylib::Module(sub,name,fullname());
}

const Module &Module::operator=(Module &module)
{
    ref_=module.ref_;
    name_=module.name_;
    prefix_=module.prefix_;
    return (*this);
}

pylib::Module init_module(vmp::str name)
{
    return pylib::Module(pylib::pymodule_init(name),name);    
}

}}

