/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 23/01/2020
 */

#include "pylib.h"

namespace vampiria { namespace pylib {

template<>
pylib::Objref *Converter<vmp_char>(vmp_char value,vmp_bool retfree)
{
     return Py_BuildValue("B",(vmp_uint)value);
}

template<>
pylib::Objref *Converter<vmp_char *>(vmp_char *value,vmp_bool retfree)
{
     if(value == 0)
         return pylib::retnone();
     return pylib::pyunicode_decode(value);  
}

template<>
pylib::Objref *Converter<vmp_uchar>(vmp_uchar value,vmp_bool retfree)
{
     return Py_BuildValue("b",(vmp_uint)value);
}

template<>
pylib::Objref *Converter<vmp_uchar *>(vmp_uchar *value,vmp_bool retfree)
{
     if(value == 0)
         return pylib::retnone();
     return pylib::pyunicode_decode((vmp_char *) value);  
}

template<>
pylib::Objref *Converter<vmp_int>(vmp_int value,vmp_bool retfree)
{
    return Py_BuildValue("i",value);
}

template<>
pylib::Objref *Converter<vmp_int *>(vmp_int *value,vmp_bool retfree)
{
    if(value == 0)
        return pylib::retnone();
    return Py_BuildValue("i",*value);     
}

template<>
pylib::Objref *Converter<vmp_uint>(vmp_uint value,vmp_bool retfree)
{
    return Py_BuildValue("I",value);
}

template<>
pylib::Objref *Converter<vmp_uint *>(vmp_uint *value,vmp_bool retfree)
{
    if(value == 0)
        return pylib::retnone();
    return Py_BuildValue("I",*value);
}

template<>
pylib::Objref *Converter<vmp_int16>(vmp_int16 value,vmp_bool retfree)
{
    return Py_BuildValue("h",value);
}

template<>
pylib::Objref *Converter<vmp_int16 *>(vmp_int16 *value,vmp_bool retfree)
{
    if(value == 0)
        return pylib::retnone();
    return Py_BuildValue("h",*value);
}

template<>
pylib::Objref *Converter<vmp_uint16>(vmp_uint16 value,vmp_bool retfree)
{
    return Py_BuildValue("H",value);
}

template<>
pylib::Objref *Converter<vmp_uint16 *>(vmp_uint16 *value,vmp_bool retfree)
{
    if(value == 0)
        return pylib::retnone();
    return Py_BuildValue("H",*value);
}

template<>
pylib::Objref *Converter<vmp_real>(vmp_real value,vmp_bool retfree)
{
    return Py_BuildValue("d",value);
}

template<>
pylib::Objref *Converter<vmp_real *>(vmp_real *value,vmp_bool retfree)
{
    if(value == 0)
        return pylib::retnone();
    return Py_BuildValue("d",*value);
}

template<>
pylib::Objref *Converter<vmp_bool>(vmp_bool value,vmp_bool retfree)
{
    return Py_BuildValue("i",value); 
}

template<>
pylib::Objref *Converter<vmp_bool *>(vmp_bool *value,vmp_bool retfree)
{
    if(value == 0)
        return pylib::retnone();
    return Py_BuildValue("i",*value);
}

template<>
pylib::Objref *Converter<vmp::str>(vmp::str value,vmp_bool retfree)
{
    return pylib::pyunicode_decode(value);
}

template<>
pylib::Objref *Converter<vmp::str *>(vmp::str *value,vmp_bool retfree)
{
    if(value == 0)
        return pylib::retnone();
    return pylib::pyunicode_decode(*value);
}

template<>
pylib::Objref *Converter<pylib::Objref *>(pylib::Objref *value,vmp_bool retfree)
{
    if(value == 0)
        return pylib::retnone();
    return Py_BuildValue("O",value); 
}

}}

