/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 13/11/2020
 */

#include "packet.h"

namespace vampiria { namespace packet {

DataMac::DataMac(vmp::str field):packet::DataBytes(field)
{
    mac_.set("00:00:00:00:00:00");
}
        
DataMac::~DataMac()
{
}

vmp::str DataMac::get(vmp::str field)
{
    return mac_.str_addr();
}
        
void DataMac::set(vmp::str field,vmp::str data)
{
    try
    {
        mac_.set(data);
    }
    catch(vmp::exception &x)
    {
        vmp::except_s("Malformed mac address");
    }
}
        
void DataMac::read(vmp::Buf *buf)
{
    net::macaddress_from_buf(&mac_,buf);
}
        
void DataMac::write(vmp::Buf *buf)
{
    net::macaddress_to_buf(&mac_,buf);
}

net::MacAddress *DataMac::get_data()
{
    return &mac_;
}

DataIpv4::DataIpv4(vmp::str field):packet::DataBytes(field)
{
    ipv4_.set_ip_raw("0.0.0.0");
}
        
DataIpv4::~DataIpv4()
{
}

vmp::str DataIpv4::get(vmp::str field)
{
    return ipv4_.ip();    
}
        
void DataIpv4::set(vmp::str field,vmp::str data)
{
    try
    {
        ipv4_.set_ip_raw(data);
        if(!ipv4_.is_ipv4())
        {
            ipv4_.set_ip_raw("0.0.0.0");
            vmp::except_s("");
        }
    }
    catch(vmp::exception &x)
    {
        vmp::except_s("Malformed ipv4 address");
    }
}
        
void DataIpv4::read(vmp::Buf *buf)
{
    net::ipv4_from_buf(&ipv4_,buf);
}
        
void DataIpv4::write(vmp::Buf *buf)
{
    net::ip_to_buf(&ipv4_,buf);
}

net::Address *DataIpv4::get_data()
{
    return &ipv4_;
}

}}

