/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 17/11/2020
 */

#include "packet.h"

namespace vampiria { namespace packet {

Arp_P::Arp_P():packet::Packet(packet::P_ARP)
{
    try
    {
        // data_[0]
        packet::DataArpHtype *htype=new packet::DataArpHtype("htype");
        insert_data(htype);
        
        // data_[1]
        packet::DataEtherType *ptype=new packet::DataEtherType("ptype");
        insert_data(ptype);

        // data_[2]
        packet::DataSize *hlen=new packet::DataSize("hlen",1);
        insert_data(hlen);
        
        // data_[3]
        packet::DataSize *plen=new packet::DataSize("plen",1);
        insert_data(plen);

        // data_[4]
        packet::DataSelect *oper=new packet::DataSelect("oper",2);
        oper->insert_code("request",1);
        oper->insert_code("reply",2);
        insert_data(oper);    
    }
    catch(vmp::exception &x)
    {
        vmp::except_s("packet::Arp_P::Arp_p() internal bugs");
    }
}
        
Arp_P::~Arp_P()
{
}

vmp::str Arp_P::next_type()
{
    packet::DataArpHtype *htype=(packet::DataArpHtype *)data_[0];
    packet::DataEtherType *ptype=(packet::DataEtherType *)data_[1];
    return packet::arpsub_str_generic(htype->get_data(),ptype->get_data());
}

Arp_Ethernet_Ipv4_P::Arp_Ethernet_Ipv4_P():packet::Packet(packet::arpsub_str_generic(1,0x0800))
{
    set_subtype(packet::P_ARP);
    
    // data_[0] -- in Arp index 5
    packet::DataMac *sha=new packet::DataMac("sha");
    insert_data(sha);

    // data_[1] -- in Arp index 6
    packet::DataIpv4 *spa=new packet::DataIpv4("spa");
    insert_data(spa);

    // data_[2] -- in Arp index 7
    packet::DataMac *tha=new packet::DataMac("tha");
    insert_data(tha);

    // data_[3] -- in Arp index 8
    packet::DataIpv4 *tpa=new packet::DataIpv4("tpa");
    insert_data(tpa);
}
        
Arp_Ethernet_Ipv4_P::~Arp_Ethernet_Ipv4_P()
{
}

}}

