/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 06/04/2022
*/

#ifndef VAMPIRIA_JSON_JTABLE_H

#define VAMPIRIA_JSON_JTABLE_H 1

namespace vampiria { namespace json {

//! JTable Class
/*!
     Used to work with JData table <string key,jData>
*/
class JTable
{
    private:
        json::JsonObj *table_;/*!<json table object references*/
        vmp::str jtype_;/*!<JData type (jtype_="" generic list not typed)*/
        friend json::JData;/*!<internal usage*/

        //! Internal usage
        void check_init(vmp::str fname);

        //! Internal usage
        void set(json::JsonObj *table,vmp::str jtype);
    public:

        //! A constructor
        JTable();

        //! A destructor
        ~JTable();

        //! Return the table json data object
        /*!
            @ref table_
            @return json object table or except in case of failure
        */
        json::JsonObj *table();

        //! Return json data types in the list
        /*!
            @ref jtype_
            @return json data types or except in case of failure
        */ 
        vmp::str jdata_type();

        //! Reset json data table
        /*!
            @ref table_
        */
        void reset();

        //! Return the list of table keys 
        /*!
            @return the list of table keys or except in case of failure
        */           
        vmp::vector<vmp::str> keys();
        
        //! Insert a jdata in the table
        /*!
            @param jkey Key associated with the jdata
            @param jdata pointer to Jdata input
            @return void or except in case of failure
        */ 
        void insert(vmp::str jkey,json::JsonObj *jdata);

        //!Delete the JData associated with the key from the table
        /*!
            @param Key associated with the jdata
            @return void or except in case of failure
        */
        void cancel(vmp::str jkey);
 
        //!Search the JData associated with the key from the table
        /*!
            @param Key associated with the jdata
            @param jdata pointer to Jdata output
            @return true data found,false data not found or except in case of failure
        */
        vmp_bool search(vmp::str jkey,json::JsonObj *jdata);
};

}}

#endif

