/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 18/09/2022
*/

#include "json.h"

namespace vampiria { namespace json {

vmp::str japi(vmp::str jtype)
{
    vmp::str ret;
    vmp::unicode::str_write(&ret,"json::%s",jtype.c_str());
    return ret;
}

vmp::str japi_type_list(vmp::str jtype)
{
    vmp::str ret;
    vmp::unicode::str_write(&ret,"[%s]",jtype.c_str());
    return ret;
}

vmp::str japi_type_table(vmp::str jtype)
{
    vmp::str ret;
    vmp::unicode::str_write(&ret,"{%s}",jtype.c_str());
    return ret;
}

void japi_void(json::JsonObj *obj)
{
    json::JData jdata;
    jdata.new_data(obj,json::japi("void"));
}

void japi_list(json::JsonObj *obj,vmp::str datatype)
{
    json::JData jdata;
    jdata.new_data(obj,json::japi_type_list(datatype));
    jdata.set_text("datatype",datatype);
    json::JList list;
    jdata.new_list("list",&list,datatype);    
}

void japi_list(json::JsonObj *obj,json::JList *list)
{
    json::JData jdata;
    vmp::except_check_pointer((void *) list,"json::japi_list() null pointer input list");
    vmp::str datatype=list->jdata_type();
    jdata.new_data(obj,json::japi_type_list(datatype));
    jdata.set_text("datatype",datatype);
    jdata.set_list("list",list,datatype); 
}

void japi_table(json::JsonObj *obj,vmp::str datatype)
{
    json::JData jdata;
    jdata.new_data(obj,json::japi_type_table(datatype));
    jdata.set_text("datatype",datatype);
    json::JTable table;
    jdata.new_table("table",&table,datatype);    
}

void japi_table(json::JsonObj *obj,json::JTable *table)
{
    json::JData jdata;
    vmp::except_check_pointer((void *) table,"json::japi_table() null pointer input table");
    vmp::str datatype=table->jdata_type();
    jdata.new_data(obj,json::japi_type_table(datatype));
    jdata.set_text("datatype",datatype);
    jdata.set_table("table",table,datatype); 
}

}}

