/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 15/05/2020
 */

#ifndef VAMPIRIA_EVENT_TIMERUI_H

#define VAMPIRIA_EVENT_TIMERUI_H 1

namespace vampiria { namespace event {

//!Event used from Timerui
class TimerRef:public event::EventTimer
{
    public:
       //!A Constructor
       TimerRef();

       //!A Destructor
       ~TimerRef();

       vmp::str id_;/*!<id event*/
};

//!Timer User interface
class TimerUI:public event::UI
{
    private:
        vmp::utils::Storage<TimerRef> tref_;/*!<Storage event*/
        event::EVTCB event_;/*!Callback event*/
        event::EVTCB cevent_;/*!Callback Close Event*/
    public:
        //!A Constructor
        /*!
            @param manager input manager
        */
        TimerUI(event::Manager *manager);
        
        //!A Destructor
        ~TimerUI();

        //!Virtual class implemented
        vmp::str identity(event::Cell *cell);
        
        //!Virtual class implemented
        void close_event(event::Cell *cell);
        
        //!Virtual class implemented
        void free_ref(event::Cell *cell);

        //!Set Timer event
        /*!
            @param event callback timer active
            @param cevent callback close event 
        */
        void set_event(event::EVTCB event,event::EVTCB cevent);

        //!Create new timer event
        /*!
            @param id id event
            @param timeval time interval to active event(> 0.0 active timer, = 0.0 create timer but not active, < 0.0 except error)
            @return cell associated with event(except error)
        */
        event::Cell *new_timer(vmp::str id,vmp::time::Time timeval=0.0);

        //!Active timer event.If already active set the new time
        /*!
            @param cell cell associated
            @param timeval time interval to active event
            @return void(except error)
        */
        void active_timer(event::Cell *cell,vmp::time::Time timeval);

        //!Deactive timer event.To reactivate it, use active_timer
        /*!
            @param cell cell associated
        */
        void deactive_timer(event::Cell *cell);

        //!Returns time interval
        /*!
            @param cell cell associated
            @return time interval
        */
        vmp::time::Time get_timeval(event::Cell *cell);

        //!Returns id event
        /*!
            @param cell cell associated
            @return id event
        */
        vmp::str id(event::Cell *cell);
};

}}

#endif

