/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 05/03/2020
 */

#include "xml_.h"

struct stub_wtag_add_child_from_tag:public pylib::Member_def<xml::WTag>
{
    pylib::Objref *def(xml::WTag *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            PyTag *tag=args.get<PyTag *>(0);
            return pylib::Converter<xml::WTag *>(instance->add_child_from_tag((xml::Tag *)tag),false); 
        }
        return 0;
    }
};

struct stub_wtag_set_child_from_tag:public pylib::Member_def<xml::WTag>
{
    pylib::Objref *def(xml::WTag *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            PyTag *tag=args.get<PyTag *>(0);
            vmp_index i=args.get<vmp_index>(1);
            return pylib::Converter<xml::WTag *>(instance->set_child_from_tag((xml::Tag *)tag,i),false); 
        }
        return 0;
    }
};

struct stub_wtag_replace_child_from_tag:public pylib::Member_def<xml::WTag>
{
    pylib::Objref *def(xml::WTag *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            PyTag *tag=args.get<PyTag *>(0);
            vmp_index i=args.get<vmp_index>(1);
            return pylib::Converter<xml::WTag *>(instance->replace_child_from_tag((xml::Tag *)tag,i),false); 
        }
        return 0;
    }
};

struct stub_wparser_init_from_tag:public pylib::Member_def<xml::WParser>
{
    pylib::Objref *def(xml::WParser *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            PyTag *tag=args.get<PyTag *>(0);
            return pylib::Converter<xml::WTag *>(instance->init_from_tag((xml::Tag *)tag),false); 
        }
        return 0;
    }
};

void xml_init_wparser(pylib::Module module)
{
    //xml.h
    pylib::Class<xml::WTag> wtag=module.class_no_constructor<xml::WTag>("WTag");
    wtag.def_("set_name",&xml::WTag::set_name);
    wtag.def_("get_name",&xml::WTag::get_name);
    wtag.def_("set_text",&xml::WTag::set_text);
    wtag.def_("get_text",&xml::WTag::get_text);
    wtag.def_("set_attr",&xml::WTag::set_attr);
    wtag.def_("get_attrs_name",&xml::WTag::get_attrs_name);
    wtag.def_("get_attr",&xml::WTag::get_attr);
    wtag.def_("del_attr",&xml::WTag::del_attr);
    wtag.def_("add_child",&xml::WTag::add_child,false);
    wtag.def_with_stub("add_child_from_tag",stub_wtag_add_child_from_tag());
    wtag.def_("add_child_from_wtag",&xml::WTag::add_child_from_wtag,false);
    wtag.def_("set_child",&xml::WTag::set_child,false);
    wtag.def_with_stub("set_child_from_tag",stub_wtag_set_child_from_tag());
    wtag.def_("set_child_from_wtag",&xml::WTag::set_child_from_wtag,false);
    wtag.def_("replace_child",&xml::WTag::replace_child,false);
    wtag.def_with_stub("replace_child_from_tag",stub_wtag_replace_child_from_tag());
    wtag.def_("replace_child_from_wtag",&xml::WTag::replace_child_from_wtag,false);
    wtag.def_("get_child_number",&xml::WTag::get_child_number);
    wtag.def_("get_child",&xml::WTag::get_child);
    wtag.def_("del_child",&xml::WTag::del_child);
    wtag.def_("get_parent",&xml::WTag::get_parent,false);

    //xml.h
    pylib::Class<xml::WParser> wparser=module.class_<xml::WParser>("WParser");
    wparser.def_("reset",&xml::WParser::reset);
    wparser.def_("get_root",&xml::WParser::get_root,false);
    wparser.def_("init",&xml::WParser::init,false);
    wparser.def_with_stub("init_from_tag",stub_wparser_init_from_tag());
    wparser.def_("init_from_wtag",&xml::WParser::init_from_wtag,false);
    wparser.def_("write_to_str",&xml::WParser::write_to_str);
    wparser.def_("write",&xml::WParser::write);
}



