/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 10/10/2023
 */

#include "json_.h"

struct stub_JsonObj_get:public pylib::Member_def<json::JsonObj>
{
    pylib::Objref *def(json::JsonObj *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
        {
            if(instance->isstr())
                return pylib::Converter<vmp::str>(instance->get_str());
            if(instance->isbool())
                return pylib::Converter<vmp_bool>(instance->get_bool());
            else if(instance->isnumber())
                return pylib::Converter<vmp_real>(instance->get_number());
            vmp::except_s("json::JsonObj::get() input object not a primitive type string,number or bool");
        }
        return 0;
    }
};

struct stub_JsonObj_get_object_value:public pylib::Member_def<json::JsonObj>
{
    pylib::Objref *def(json::JsonObj *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp::str key=args.get<vmp::str>(0);
            json::JsonObj obj;
            instance->get_object(key,&obj);
            if(obj.isstr())
                return pylib::Converter<vmp::str>(obj.get_str());
            if(obj.isbool())
                return pylib::Converter<vmp_bool>(obj.get_bool());
            else if(obj.isnumber())
                return pylib::Converter<vmp_real>(obj.get_number());
            vmp::except("json::JsonObj::get_object_value() object key='%s' not a primitive type string,number or bool",key.c_str());
        }
        return 0;
    }
};

void json_init(pylib::Module module)
{
    pylib::Class<json::Json> json=module.class_<json::Json>("Json");
    json.def_("root",&json::Json::root,false);
    json.def_("root_cpy",&json::Json::root_cpy);
    json.def_("json_new",&json::Json::json_new,false);
    json.def_("json_new_obj",&json::Json::json_new_obj,false);
    json.def_("json_duplicate",&json::Json::json_duplicate,false);
    json.def_("parse_from_str",&json::Json::parse_from_str,false);
    json.def_("parse_from_file",&json::Json::parse_from_file,false);
    json.def_("json_str",&json::Json::json_str);
    json.def_("json_str_format",&json::Json::json_str_format);
    json.def_("json_to_file",&json::Json::json_to_file);

    pylib::Class<json::JsonObj> jsonobj=module.class_<json::JsonObj>("JsonObj");

    jsonobj.def_("isnull",&json::JsonObj::isnull);
    jsonobj.def_("isstr",&json::JsonObj::isstr);
    jsonobj.def_("isbool",&json::JsonObj::isbool);
    jsonobj.def_("isnumber",&json::JsonObj::isnumber);
    jsonobj.def_("isarray",&json::JsonObj::isarray);
    jsonobj.def_("isobject",&json::JsonObj::isobject);
    jsonobj.def_("keys",&json::JsonObj::keys);
    jsonobj.def_("get_object",&json::JsonObj::get_object);
    jsonobj.def_("del_object",&json::JsonObj::del_object);
    jsonobj.def_("add_object_str",&json::JsonObj::add_object_str);
    jsonobj.def_("add_object_null",&json::JsonObj::add_object_null);
    jsonobj.def_("add_object_bool",&json::JsonObj::add_object_bool);
    jsonobj.def_("add_object_number",&json::JsonObj::add_object_number);
    jsonobj.def_("add_object_array",&json::JsonObj::add_object_array);
    jsonobj.def_("add_object_obj",&json::JsonObj::add_object_obj);
    jsonobj.def_("add_object_ex",&json::JsonObj::add_object_ex);
    jsonobj.def_("get_str",&json::JsonObj::get_str);
    jsonobj.def_("get_bool",&json::JsonObj::get_bool);
    jsonobj.def_("get_number",&json::JsonObj::get_number);
    jsonobj.def_("get_array_size",&json::JsonObj::get_array_size);
    jsonobj.def_("get_array_idx",&json::JsonObj::get_array_idx);
    jsonobj.def_("push_array_str",&json::JsonObj::push_array_str);
    jsonobj.def_("push_array_null",&json::JsonObj::push_array_null);
    jsonobj.def_("push_array_bool",&json::JsonObj::push_array_bool);
    jsonobj.def_("push_array_number",&json::JsonObj::push_array_number);
    jsonobj.def_("push_array_array",&json::JsonObj::push_array_array);
    jsonobj.def_("push_array_obj",&json::JsonObj::push_array_obj);
    jsonobj.def_("push_array_obj_ex",&json::JsonObj::push_array_obj_ex);
    jsonobj.def_("replace_array_str",&json::JsonObj::replace_array_str);
    jsonobj.def_("replace_array_null",&json::JsonObj::replace_array_null);
    jsonobj.def_("replace_array_bool",&json::JsonObj::replace_array_bool);
    jsonobj.def_("replace_array_number",&json::JsonObj::replace_array_number);
    jsonobj.def_("replace_array_array",&json::JsonObj::replace_array_array);
    jsonobj.def_("replace_array_obj",&json::JsonObj::replace_array_obj);
    jsonobj.def_("replace_array_obj_ex",&json::JsonObj::replace_array_obj_ex);
    jsonobj.def_("get_object_str",&json::JsonObj::get_object_str);
    jsonobj.def_("get_object_bool",&json::JsonObj::get_object_bool);
    jsonobj.def_("get_object_number",&json::JsonObj::get_object_number);
    jsonobj.def_("get_object_array_strings",&json::JsonObj::get_object_array_strings);
    jsonobj.def_("get_object_array_numbers",&json::JsonObj::get_object_array_numbers);
    jsonobj.def_("get_object_array_bools",&json::JsonObj::get_object_array_bools);
    jsonobj.def_("add_object_array_strings",&json::JsonObj::add_object_array_strings);
    jsonobj.def_("push_array_array_strings",&json::JsonObj::push_array_array_strings);
    jsonobj.def_("replace_array_array_strings",&json::JsonObj::replace_array_array_strings);
    jsonobj.def_("add_object_array_bools",&json::JsonObj::add_object_array_bools);
    jsonobj.def_("push_array_array_bools",&json::JsonObj::push_array_array_bools);
    jsonobj.def_("replace_array_array_bools",&json::JsonObj::replace_array_array_bools);
    jsonobj.def_("add_object_array_numbers",&json::JsonObj::add_object_array_numbers);
    jsonobj.def_("push_array_array_numbers",&json::JsonObj::push_array_array_numbers);
    jsonobj.def_("replace_array_array_numbers",&json::JsonObj::replace_array_array_numbers);
    jsonobj.def_("add_object_array_nulls",&json::JsonObj::add_object_array_nulls);
    jsonobj.def_("push_array_array_nulls",&json::JsonObj::push_array_array_nulls);
    jsonobj.def_("replace_array_array_nulls",&json::JsonObj::replace_array_array_nulls);
    
    jsonobj.def_with_stub("get",stub_JsonObj_get());
    jsonobj.def_with_stub("get_object_value",stub_JsonObj_get_object_value());  
}

VAMPIRIA_PYLIB_INIT(vmp_json_);

void vampiria_pylib_init_module(pylib::Module init_module)
{
    json_init(init_module);
    json_jdata(init_module);
    json_jlist(init_module);
    json_jtable(init_module);
    json_japi(init_module);
    json_jrp(init_module);
}

