/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 10/10/2023
*/

#include "json_.h"

void json_jrp(pylib::Module module)
{
    pylib::Module jrp=module.add_submodule("jrp");
    jrp.add_const<vmp_int>("status_ok",json::jrp::status_ok);
    jrp.add_const<vmp_int>("status_err",json::jrp::status_err);
    jrp.add_const<vmp_int>("status_malformed_msg",json::jrp::status_malformed_msg);
    jrp.add_const<vmp_int>("status_undef_datatype",json::jrp::status_undef_datatype);
    jrp.add_const<vmp_int>("status_accessdenied",json::jrp::status_accessdenied);
    jrp.add_const<vmp_int>("status_duplexsession",json::jrp::status_duplexsession);
    jrp.add_const<vmp_int>("status_protocolbad",json::jrp::status_protocolbad);
    jrp.add_const<vmp_int>("status_closeconnection",json::jrp::status_closeconnection);
    jrp.add_const<vmp_int>("status_timeout",json::jrp::status_timeout);
    jrp.add_const<vmp_int>("status_killed",json::jrp::status_killed);
    jrp.add_const<vmp_int>("status_input_bad",json::jrp::status_input_bad);
    jrp.add_const<vmp_int>("status_input_notmanaged",json::jrp::status_input_notmanaged);
    jrp.add_const<vmp_int>("status_rid_duplex",json::jrp::status_rid_duplex);
    jrp.def_("msg_status",json::jrp::msg_status);
}

