/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 24/01/2023
 */

#include "vmp_.h"

VAMPIRIA_PYLIB_INIT(vmp_);

struct stub_except_s:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        vmp::str arg0;
        if(args.size() == 1)
        {
            arg0=args.get<vmp::str>(0);
            try
            {
                vmp::except_s(arg0);
            }
            catch(vmp::exception &x)
            {
                vmp::except_runtime(x.what());
            } 
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_init:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        vmp::str arg0;
        vmp_bool arg1=false;
        if(args.size() == 1)
        {
            arg0=args.get<vmp::str>(0);     
        }
        else if(args.size() == 2)
        {
            arg0=args.get<vmp::str>(0);
            arg1=args.get<vmp_bool>(1);
        }
        else
            return 0;
        vmp::init(arg0,arg1);
        return pylib::retnone();
    }
};

struct stub_rand_wrap:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
            return pylib::Converter<vmp_uint>(vmp::rand_wrap());
        else if(args.size() == 1)
        {
            vmp_uint hop=args.get<vmp_uint>(0);
            return pylib::Converter<vmp_uint>(vmp::rand_wrap(hop));
        }
        return 0; 
    }
};
static vmp::Table<vmp_int,pylib::PyCall *> sigcall_;

void signal_handler(vmp_int sig)
{
    pylib::GilState gstate=pylib::gil_ensure();
    pylib::PyCall *ret;
    if(sigcall_.search(sig,&ret))
    {
        pylib::CArgs args(1);
        args.add<vmp_int>(sig);
        pylib::PyObj res=ret->call(args);
        res.reset();
    }
    pylib::gil_release(gstate);
}

struct stub_signal_wrap:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp::vector<vmp::str> arg0=args.get<vmp::vector<vmp::str> >(0);
            pylib::PyCall arg1;
            args.get_callable(1,arg1);
            if(arg0.size() != 0)
            {
                vmp::signal_wrap(arg0,signal_handler);
                for(vmp_index i=0;i<arg0.size();i++)
                {
                    pylib::PyCall *tmp=new pylib::PyCall();
                    (*tmp)=arg1;
                    sigcall_.update(vmp::signum(arg0[i]),&tmp);
                    if(tmp != 0)
                        delete tmp;
                }
            }
            return pylib::retnone();
        }
        return 0; 
    }
};

void vmp_init(pylib::Module module)
{
    //vmp/basetypes.h
    module.add_const<vmp_int>("INTMIN",vmp::INTMIN);
    module.add_const<vmp_int>("INTMAX",vmp::INTMAX);
    module.add_const<vmp_int16>("INT16MIN",vmp::INT16MIN);
    module.add_const<vmp_int16>("INT16MAX",vmp::INT16MAX);
    module.add_const<vmp_uint>("UINTMIN",vmp::UINTMIN);
    module.add_const<vmp_uint>("UINTMAX",vmp::UINTMAX);
    module.add_const<vmp_uint16>("UINT16MIN",vmp::UINT16MIN);
    module.add_const<vmp_uint16>("UINT16MAX",vmp::UINT16MAX);
    module.add_const<vmp_char>("CHARMIN",vmp::CHARMIN);
    module.add_const<vmp_char>("CHARMAX",vmp::CHARMAX);
    module.add_const<vmp_uchar>("UCHARMIN",vmp::UCHARMIN);
    module.add_const<vmp_uchar>("UCHARMAX",vmp::UCHARMAX);
    module.add_const<vmp_uint>("RANDMAX",vmp::RANDMAX);

    //vmp/error.h
    module.def_with_stub("except_s",stub_except_s());

    //vmp/io.h
    module.def_with_stub("init",stub_init());
    module.def_("is_debug_mode",vmp::is_debug_mode);
    module.def_("id",vmp::id);
    module.def_("io_forced_unlock",vmp::io_forced_unlock);
    module.def_("io_recovery_lock",vmp::io_recovery_lock);
    module.def_("debug",vmp::debug_s);
    module.def_("info",vmp::info_s);
    module.def_("warning",vmp::warning_s);
    module.def_("error",vmp::error_s);
    module.def_("error_raw",vmp::error_raw_s);
    module.def_("output",vmp::output_s);
    module.def_("output_raw",vmp::output_raw_s);
    module.def_("output_file",vmp::output_file_s);
    module.def_("output_file_lines",vmp::output_file_lines);
    module.def_("input",vmp::input);
    module.def_("input_file",vmp::input_file);
    module.def_("input_file_s",vmp::input_file_s);
    module.def_("exit_ok",vmp::exit_ok);
    module.def_("exit_failure",vmp::exit_failure_s);
    module.def_("copy_file",vmp::copy_file);
    module.def_("move_file",vmp::move_file);

    //vmp/lib.h
    module.def_("system_wrap",vmp::system_wrap);
    module.def_("pause_wrap",vmp::pause_wrap);
    module.def_("getpid_wrap",vmp::getpid_wrap);
    module.def_("getuid_wrap",vmp::getuid_wrap);
    module.def_("geteuid_wrap",vmp::geteuid_wrap);
    module.def_("dup2_wrap",vmp::dup2_wrap);
    module.def_("kill_wrap",vmp::kill_wrap);
    module.def_("fd_noblock",vmp::fd_noblock);
    module.def_("fd_block",vmp::fd_block);
    module.def_("fd_fsync",vmp::fd_fsync);
    module.def_("srand_wrap",vmp::srand_wrap);
    module.def_with_stub("rand_wrap",stub_rand_wrap());
   
    //vmp/signal.h
    module.def_("signum",vmp::signum);
    module.def_("sigstr",vmp::sigstr);
    module.def_("sigcmp",vmp::sigcmp);
    module.def_with_stub("signal_wrap",stub_signal_wrap());
}

void vampiria_pylib_init_module(pylib::Module init_module)
{
   vmp_init(init_module);
   vmp_init_env(init_module);
   vmp_init_buf(init_module);
   vmp_init_fs(init_module);
   vmp_init_thread(init_module);
   vmp_init_time(init_module);
   vmp_init_unicode(init_module);
   vmp_init_utils(init_module);
}

