/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 07/10/2023
 */

#include "vmp_.h"

struct stub_str_regex:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         vmp::str str;
         vmp::str regex;
         vmp_bool icase;
         if(args.size() == 2)
         {
             str=args.get<vmp::str>(0);     
             regex=args.get<vmp::str>(1);
             return pylib::Converter<vmp::vector<vmp::str> >(vmp::unicode::str_regex(str,regex));
         }
         else if(args.size() == 3)
         {
             str=args.get<vmp::str>(0);
             regex=args.get<vmp::str>(1);
             icase=args.get<vmp_bool>(2);
             return pylib::Converter<vmp::vector<vmp::str> >(vmp::unicode::str_regex(str,regex,icase));
         }
         else
             return 0;
         
   }
};

struct PyStrtok_stub_Constructor:public pylib::Constructor<vmp::unicode::Strtok>
{
    vmp::unicode::Strtok *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
            return new vmp::unicode::Strtok();
        else if(args.size() == 1)
        {
            vmp::str content=args.get<vmp::str>(0);
            return new vmp::unicode::Strtok(content);
        }
        return 0;
    }
};

void vmp_init_unicode(pylib::Module module)
{
    pylib::Module unicode=module.add_submodule("unicode");

    // vmp/unicode.h
    unicode.def_("str_split",vmp::unicode::str_split);
    unicode.def_("str_join",vmp::unicode::str_join);
    unicode.def_("str_istype",vmp::unicode::str_istype);
    unicode.def_("str_isdigit",vmp::unicode::str_isdigit);
    unicode.def_("str_isxdigit",vmp::unicode::str_isxdigit);
    unicode.def_("str_isreal",vmp::unicode::str_isreal);
    unicode.def_("str_todigit",vmp::unicode::str_todigit);
    unicode.def_("str_todigit_range",vmp::unicode::str_todigit_range);
    unicode.def_("str_toreal",vmp::unicode::str_toreal);
    unicode.def_("str_toreal_range",vmp::unicode::str_toreal_range);
    unicode.def_("xstr_tobytes",vmp::unicode::xstr_tobytes);
    unicode.def_("bytes_toxstr",vmp::unicode::bytes_toxstr);
    unicode.def_("bytes_toxstr_hm",vmp::unicode::bytes_toxstr_hm);
    unicode.def_("str_toxstr",vmp::unicode::str_toxstr);
    unicode.def_("xstr_tostr",vmp::unicode::xstr_tostr);
    unicode.def_("str_sub",vmp::unicode::str_sub);
    unicode.def_("str_findsub",vmp::unicode::str_findsub);
    unicode.def_("str_replace",vmp::unicode::str_replace);
    unicode.def_("str_casecmp",vmp::unicode::str_casecmp);
    unicode.def_("str_trim",vmp::unicode::str_trim);
    unicode.def_("str_isword",vmp::unicode::str_isword);
    unicode.def_("str_format",vmp::unicode::str_format);
    unicode.def_("str_format_maxline",vmp::unicode::str_format_maxline);
    unicode.def_("str_format_end",vmp::unicode::str_format_end);
    unicode.def_("str_extract_char",vmp::unicode::str_extract_char);
    unicode.def_("str_remove_duplex",vmp::unicode::str_remove_duplex);
    unicode.def_with_stub("str_regex",stub_str_regex());
    unicode.def_("str_regex_matching",vmp::unicode::str_regex_matching);
    unicode.def_("str_invector",vmp::unicode::str_invector);
    unicode.def_("shlex_split",vmp::unicode::shlex_split);
    unicode.def_("shlex_join",vmp::unicode::shlex_join);
    unicode.def_("b64_encode",vmp::unicode::b64_encode);
    unicode.def_("b64_decode",vmp::unicode::b64_decode);
    unicode.def_("utf8_check",vmp::unicode::utf8_check);

    pylib::Class<vmp::unicode::Strtok> strtok=module.class_with_constructor<vmp::unicode::Strtok>("Strtok",PyStrtok_stub_Constructor());
    strtok.def_("reset",&vmp::unicode::Strtok::reset);
    strtok.def_("set",&vmp::unicode::Strtok::set);
    strtok.def_("next",&vmp::unicode::Strtok::next);
    strtok.def_("get_char",&vmp::unicode::Strtok::get_char);
    strtok.def_("jump_chars",&vmp::unicode::Strtok::jump_chars);
}

