#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 14/10/2023

import vmpsys as sys

##Vampiria Author
author_="Marco Guastella alias Vasta"

##Author mail
email_="vasta@ragnu.it"

##Project Web page
webpage_="http://www.ragnu.it"

##Vampiria license
license_="GPL3"

##Vampiria version
version_="0.5.1"

##Vampiria release type
release_="alpha"

##Vampiria directory path section

##Root directory vampira
root_=sys.path()

##add / to end of path if not present<BR>
#
#@param path input path
def config_path(path):
  if len(path) == 0:
    return '/'
  if path[len(path)-1] != '/':
    return "{0}/".format(path)
  return path

##Framework directory path section

##Framework lib path
fwlib_="framework/lib/"

##Framework c++ src path
fwsrc_="framework/src/"

##Framework python lib path
fwpylib_="framework/python/"

##Framework python lib shared object
fwpylibso_="framework/pylib/"

##Framework main path
fwmain_="framework/main/"

##Framework python main executable
fwmainexe_="vmpmain.py"

##Installer path
installer_="framework/main/install.py"

##Uninstaller path
uninstaller_="framework/main/uninstall.py"

##Framework doc path
fwdoc_="framework/doc/lib/"

##Framework dtd path
fwdtd_="framework/dtd/"

##General directory path section

##Python enviroment
gpyenv_="pyenv/"

##python package root directory
gvpkg_="vpkg/"

##Software directory path
gsoftware_="software/"

##Software path<BR>
#
#@param software software name
def gsoftware_path(software):
  return "{0}{1}/".format(gsoftware_,software)

##Name of the reference file used for installing the software components
ginstalledf_="installed"

##Returns the absolute path the installed file<BR>
#
#@param dirpath directory path<BR
#@return complete path
def ginstalled_(dirpath):
  return "{0}{1}".format(config_path(dirpath),ginstalledf_,)

##File name python main software
gpymain_="main.py"

##Cache directory path
gcache_="cache/"

##executable directory path
gexec_="bin/"

##lib external framework directory path
glib_="lib/"

##modules directory path
gmodules_="{0}vmodules/".format(gpyenv_)

##Modules directory path<BR>
#
#@param modname module name
def gmodule_path_(modname):
  return "{0}{1}/".format(gmodules_,modname)

##Subdirectory to locate main in module
gmodulemain_="main/"

##Returns module main directory path<BR>
#
#@param modname module name
def gmodule_main_(modname):
  return "{0}{1}".format(gmodule_path_(modname),gmodulemain_)

##manifest module file
gmodulemanifest_="manifest.xml"

##Returns manifest module path<BR>
#
#@param modname module name
def gmodulemanifest_path_(modname):
  main=gmodule_main_(modname)
  return "{0}{1}".format(main,gmodulemanifest_)

##dtd module file
gmoduledtd_="module.dtd"

##Module import preamble
gmoduleimp_="vmodules"

##xml module header
gmodulexmlhdr_="<?xml version='1.0' encoding='iso-8859-1'?>"

##home directory path
ghome_="home/"

##package directory
gpkg_="pkg/"

##Python section

##Python interpreter used
python_=sys.executable()

##Version less python version for installer
pyversion_=(3,11)

##Python library directory src files<BR>
#
#@param name python library name<BR>
#@param root python root library
def pysrc_(name,root):
  return "{0}{1}/src/".format(config_path(root),name)

##Python library directory target <BR>
#
#@param name python library name<BR>
#@param root python root library(if root=='' default framework lib is associated)
def pydirtarget_(name,root=''):
  if root == '':
    return "{0}{1}/".format(fwpylib_,name)
  else:
    return "{0}{1}/".format(config_path(root),name)

##Append subdir python lib<BR>
#
#@param name:lib name<BR>
#@param root: python root library(if root=='' default framework lib is associated)<BR>
def pylib_subdir(name,root=''):
  if root == '':
    sys.append_subdir("{0}{1}/".format(fwpylib_,name))
  else:
    sys.append_subdir("{0}{1}/".format(config_path(root),name))

##Append directory vampiria env in python sys.path()
def pyenv():
  sys.append_subdir(fwpylib_)
  sys.append_subdir(fwpylibso_)
  sys.append_subdir(gpyenv_)
  sys.append_subdir(gvpkg_)
  
##Append directory home in python sys.path
#
#@param dirhome directory home
def pyhome_add(dirhome):
  sys.append_subdir(dirhome)

##Remove directory home in python sys.path<BR>
#
#@param dirhome directory home
def pyhome_remove(dirhome):
  sys.remove_subdir(dirhome)

##Python clean check command
pyclean_check_=['py3clean','--version']

##Python clean cmd
pyclean_cmd_="py3clean -v {0}".format(root_)

##Cpp section

##Compiler help command
cpp_help_=['g++','--help']

##Compiler command<BR>
#
#@param included compiler included path(source framework already inserted by default)<BR>
#@param options  compiler option list<BR>
#
#@return cpp compiler string
def cpp_(included,options):
  cpp="g++ -ggdb -Wall -fPIC -I {0}".format(sys.path(fwsrc_))
  for inc in included:
    cpp="{0} -I {1}".format(cpp,inc)
  for opt in options:
    cpp="{0} {1}".format(cpp,opt)
  cpp="{0} -c".format(cpp) 
  return cpp 

##Linker build so library<BR>
#
#@return cpp linker string (build shared object) 
def cppso_():
  return "g++ -ggdb -shared -Wl,-rpath,."
  
##Linker build binary files<BR>
#
#@return cpp linker string(build binary file)
def cppbin_():
  return "g++ -ggdb"
  
##Check c header help command
cpphdr_help_=["cpp","--help"]

##Command c search header<BR>
#
#@param hdr c header to search<BR>
#@return string search cpp header in system
def cpphdr_cmd_(hdr):
  return "echo '#include <{0}>' | cpp -H -o /dev/null > /dev/null 2>&1".format(hdr)

##Check pkg-config help command
pkgconfig_help_=["pkg-config","--help"]

##config.h framework define
configlist_= ["/*Config file autogenerate from install*/",
              "",
              "#ifndef VAMPIRIA_CONFIG_H",
              "",
              "#define VAMPIRIA_CONFIG_H 1",
              "",
              "namespace vampiria {",
              "",
              "#define VAUTHOR             \"{0}\"".format(author_),
              "#define VEMAIL              \"{0}\"".format(email_),
              "#define VWEBPAGE            \"{0}\"".format(webpage_),
              "#define VLICENSE            \"{0}\"".format(license_),
              "#define VVERSION            \"{0}_{1}\"\n".format(version_,release_),
              "#define VPATH               \"{0}\"".format(root_),
              "#define VEXEC               \"{0}\"".format(sys.path(gexec_)),
              "#define VLIB                \"{0}\"".format(sys.path(glib_)),
              "#define VCACHE              \"{0}\"".format(sys.path(gcache_)),
              "#define VHOME               \"{0}\"".format(sys.path(ghome_)),
              "#define VSOFTWARE           \"{0}\"".format(sys.path(gsoftware_)),
              "#define VINSTALLEDF         \"{0}\"".format(ginstalledf_),
              "#define VMODULES            \"{0}\"".format(sys.path(gmodules_)),
              "#define VMODMAIN            \"{0}\"".format(gmodulemain_),
              "#define VMANIFEST           \"{0}\"".format(gmodulemanifest_),
              "#define VPKG                \"{0}\"".format(sys.path(gpkg_)),
              "#define VVPKG               \"{0}\"".format(sys.path(gvpkg_)),
              "#define FDTD                \"{0}\"".format(sys.path(fwdtd_)),
              "#define VPYTHON             \"{0}\"".format(python_),
              "#define VPYENV              \"{0}\"".format(sys.path(gpyenv_)),
              "#define VPYMODULEIMP        \"{0}\"".format(gmoduleimp_),
              "#define VPYMAIN             \"{0}{1}{2}\"".format(root_,fwmain_,fwmainexe_),
              "#define VPYMAINAME          \"{0}\"".format(gpymain_),
              "#define VXMLHDR             \"{0}\"".format(gmodulexmlhdr_),  
              "",
              "}",
              "",
              "#endif",
              ""
             ]

