#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 18/03/2020

import vmpconfig   as config
import vmpbuild    as build
import vmpsys      as sys
import vmpcheck    as check

name="vampiria"

setup=build.setup()
setup.name=name
setup.path=config.gsoftware_path(name)
setup.files=[('./',['main','opt_','process_']),('tag/',['tag_','tag_env_','tag_module_','tag_std_'])]
setup.dirtarget=config.gexec_
setup.dependencies=['vmp','process','xml','modules']

def description():
    return "Runs a modular process system configured via an xml input file"

def install():
    sys.config_create("{0}config_.h".format(sys.path(setup.path)),["/*Config file autogenerate from install*/\n","#ifndef VAMPIRIA_SOFTWARE_CFG_H\n\n#define VAMPIRIA_SOFTWARE_CFG_H 1\n","#define VAMPIRIA_DTDPATH \"vampiria.dtd\"\n","#endif"])
    build.cbuild(setup)
    check.check_software([],["vmpproxy"])
    
def uninstall():
  sys.config_remove("{0}config_.h".format(sys.path(setup.path)))
  build.cclear(setup)

