/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 22/12/2018
 */

#include "main.h"

//! Usage topic
vmp::str usage()
{
    vmp::str error;
    vmp::unicode::str_cwrite(&error,"Usage:   vampiria -h\t\t : Help topic");
    vmp::unicode::str_cwrite(&error,"\n\t vampiria -i\t\t : info release");
    vmp::unicode::str_cwrite(&error,"\n\t vampiria -v\t\t : Version");
    vmp::unicode::str_cwrite(&error,"\n\t vampiria -l\t\t : Modules list");
    vmp::unicode::str_cwrite(&error,"\n\t vampiria -m {modname}\t : Module topic");
    vmp::unicode::str_cwrite(&error,"\n\t vampiria -p\t\t : Root path");
    vmp::unicode::str_cwrite(&error,"\n\t vampiria -c {file.xml}\t : Check xml file input");
    vmp::unicode::str_cwrite(&error,"\n\t vampiria -d {file.xml}  : Performing xml file (debug mode)");
    vmp::unicode::str_cwrite(&error,"\n\t vampiria -r {file.xml}  : Performing xml file");
    return error;
}

void opt_info(vmp_int argc,vmp_char *const argv[],vmp_char *optarg)
{
    if(argc == 2)
    {
        vmp::output("Software version: %s",vmp::env::version().c_str());
        vmp::output("Author: %s",vmp::env::author().c_str());
        vmp::output("Web page: %s",vmp::env::webpage().c_str());
        vmp::output("Email: %s",vmp::env::email().c_str());
        vmp::output("License: %s",vmp::env::license().c_str());
        exit_ok();
    }
}

void opt_helper(vmp_int argc,vmp_char *const argv[],vmp_char *optarg)
{
    if(argc == 2)
    {
        vmp::output("%s",usage().c_str());
        exit_ok();
    }
}

void opt_version(vmp_int argc,vmp_char *const argv[],vmp_char *optarg)
{
    if(argc == 2)
    {
        vmp::output("%s",vmp::env::version().c_str());
        exit_ok();
    }
}

void opt_modlist(vmp_int argc,vmp_char *const argv[],vmp_char *optarg)
{
    Vampiria *vmp=vmp::Instance::get_global<Vampiria>();
    if(argc == 2)
    {
        try
        {
            vmp::output("%s",vmp->modules_.list().c_str());
            exit_ok();
        }
        catch(vmp::exception &x)
        {
            exit_failure(x.what());
        }
    }
}

void opt_modtopic(vmp_int argc,vmp_char *const argv[],vmp_char *optarg)
{
    Vampiria *vmp=vmp::Instance::get_global<Vampiria>();
    if(argc == 3)
    {
        try
        {
            vmp::output("%s",vmp->modules_.topic(optarg).c_str());
            exit_ok();
        }
        catch(vmp::exception &x)
        {
            exit_failure(x.what());
        }
    }
}

void opt_rootpath(vmp_int argc,vmp_char *const argv[],vmp_char *optarg)
{
    if(argc == 2)
    {
        vmp::output("%s",vmp::env::vampiria_path().c_str()); 
        exit_ok();
    }
}

void opt_check(vmp_int argc,vmp_char *const argv[],vmp_char *optarg)
{
    Vampiria *vmp=vmp::Instance::get_global<Vampiria>();
    if(argc == 3)
    {
        vmp->mode_=CHECK;
        vmp->args_=optarg;
    }
}

void opt_debug(vmp_int argc,vmp_char *const argv[],vmp_char *optarg)
{
    vmp::init("vampiria",true);
    opt_run(argc,argv,optarg);
}


void opt_run(vmp_int argc,vmp_char *const argv[],vmp_char *optarg)
{
    Vampiria *vmp=vmp::Instance::get_global<Vampiria>();
    if(argc == 3)
    {
        vmp->mode_=RUN;
        vmp->args_=optarg;
    }
}

