#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 18/03/2020

import vmpconfig  as config
import vmpsys     as sys
import vmpcheck   as check
import vmpbuild   as build
import vmppybuild as pybuild

name="gvampiria"

setup=build.setup()
setup.name=name
setup.path=config.gsoftware_path(name)
setup.files=[('./exe/',['main'])]
setup.dirtarget=config.gexec_
setup.dependencies=['vmp','process']

pysetup=pybuild.pysetup()
pysetup.dependencies=['vmp','vmp_xml','vmp_net','vmp_xterm0','vmp_gui0']

def description():
    return "Graphic interface used for the creation of the xml files used by the vampiria parsing software and the automatic execution of these software"

def install():
    sys.config_create("{0}exe/config_.h".format(sys.path(setup.path)),["/*Config file autogenerate from install*/\n","#ifndef GVAMPIRIA_SOFTWARE_CFG_H\n\n#define GVAMPIRIA_SOFTWARE_CFG_H 1\n","const vmp::str ID_=\"{0}\";\n".format(setup.name),"#endif"])
    build.cbuild(setup)
    pybuild.pybuild(pysetup)
    check.check_software(["vampiria"],["vmpproxy"])
    check.check_modules([],["system","helper"])

def uninstall():
    sys.config_remove("{0}exe/config_.h".format(sys.path(setup.path)))
    build.cclear(setup)
    pybuild.pyclear(pysetup)

