/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 24/09/2022
 */

#include "rawnet2/rawnet2.h"

namespace vampiria { namespace rawnet { namespace pkg {

Dumper::Dumper()
{
    dumper_=0;
    handle_=0;
}
        
Dumper::~Dumper()
{
    close();
}

void Dumper::open(vmp::str wfile,vmp_int linktype)
{
    if(handle_ != 0)
        close();
    handle_=rawnet::pkg::open_dead(linktype,65535);
    dumper_=rawnet::pkg::open_dumper(handle_,wfile.c_str());
}

void Dumper::dump(vmp::Buf *buf)
{
    rawnet::pkg::write_dumper(dumper_,buf);
}

void Dumper::close()
{
    rawnet::pkg::close_rawnet(&handle_);
    rawnet::pkg::close_dumper(&dumper_);
}

Offline::Offline()
{
    dlink_=-1;
}
        
Offline::~Offline()
{
    reset();
}
        
void Offline::reset()
{
    dlink_=-1;
    vmp::vector_delete_alldata<vmp::Buf *>(data_);
}

void read_offline(vmp::Buf *buf,void *arg)
{
    rawnet::pkg::Offline *offline=(rawnet::pkg::Offline *)arg;
    offline->add(buf);
}
       
vmp_int Offline::read(vmp::str file,vmp::str filter)
{
    rawnet::pkg::rawnet_t handle=open_offline(file);
    vmp_int dlink=rawnet::pkg::datalink_rawnet(handle);
    if((dlink_ != -1) && (dlink_ != dlink))
         vmp::except("rawnet::pkg::Offline::read() error read file %s 'datalink type different from previously read files'");
    dlink_=dlink;
    try
    {
        rawnet::pkg::filter_rawnet(handle,filter);
        rawnet::pkg::loop_rawnet(handle,read_offline,(void *)this);
    }
    catch(vmp::exception &x)
    {
        vmp::except("rawnet::pkg::Offline::read() error read file %s '%s'",file.c_str(),x.what());
    }
    rawnet::pkg::close_rawnet(&handle);
    return dlink_;
}
        
vmp_size Offline::data_size()
{
    return data_.size();
}

void Offline::add(vmp::Buf *buf)
{
    if(buf != 0)
    {
       vmp::Buf *tmp=new vmp::Buf();
       tmp->write_buf(buf);
       data_.push_back(tmp);
    }
}
       
vmp::Buf *Offline::get(vmp_index i)
{
    if(i < data_size())
    {
        data_[i]->index();
        return data_[i];
    }
    return 0;
}

void read_filter_file(vmp::Buf *buf,void *arg)
{
    rawnet::pkg::Dumper *dumper=(rawnet::pkg::Dumper *)arg;
    dumper->dump(buf);
}

void filter_file(vmp::str finput,vmp::str foutput,vmp::str filter)
{
    rawnet::pkg::rawnet_t handle=open_offline(finput);
    rawnet::pkg::Dumper dumper;
    try
    {
        vmp_int dlink=rawnet::pkg::datalink_rawnet(handle);    
        rawnet::pkg::filter_rawnet(handle,filter);
        dumper.open(foutput,dlink);
        rawnet::pkg::loop_rawnet(handle,read_filter_file,(void *)&dumper);
    }
    catch(vmp::exception &x)
    {
        rawnet::pkg::close_rawnet(&handle);
        vmp::except_s(x.what());
    }
    rawnet::pkg::close_rawnet(&handle);
}

vmp::str linktype_str_generic(vmp_int linktype)
{
    vmp::str ret="";
    if(linktype >= 0)
        vmp::unicode::str_write(&ret,"pcap_%d",linktype);
    else
        vmp::except("rawnet::pkg::linktype_str_generic() invalid linktype '%d'",linktype);
    return ret;
}

vmp::str linktype_str(vmp_int linktype)
{
    switch(linktype)
    {
        case DLT_EN10MB:
            return packet::P_ETHERNET;
        default:
            break;
    }
    return rawnet::pkg::linktype_str_generic(linktype);
}

}}}

