/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 13/10/2022
*/

#include "openssl2/openssl2.h"

namespace vampiria { namespace openssl { namespace jrp { namespace pkg {

void JrpUI::send_abort(event::Cell *cell,vmp_int status,vmp::str msg)
{
    openssl::jrp::pkg::JrpSslEv *evtssl=cell->event<openssl::jrp::pkg::JrpSslEv>();
    vmp::Buf buf;
    openssl::jrp::pkg::jrp_abort(&buf,status,msg);
    try
    {
        evtssl->evt_ssl_send(&buf);
    }
    catch(vmp::exception &x)
    {
    }
    evtssl->status_=status;
    if(msg == "")
        msg=openssl::jrp::pkg::msg_status(evtssl->status_);
    vmp::unicode::str_write(&(evtssl->msg_),"send_abort('%s')",msg.c_str());
    manager_->cell_timewait(cell,3.0);
    evtssl->recv_=ssl_recv_close;
}

void JrpUI::send(vmp::str fingerprint,vmp::Buf *buf)
{
    try
    {
        event::Cell *cell=get_cell(fingerprint);
        openssl::jrp::pkg::JrpSslEv *evtssl=cell->event<openssl::jrp::pkg::JrpSslEv>();
        if(!evtssl->isclose_)
            evtssl->evt_ssl_send(buf);  
    }
    catch(vmp::exception &x)
    {
    }
}

event::Cell *JrpUI::get_cell(vmp::str fingerprint)
{
    event::Cell *ret=0;
    if(!sessions_.search(fingerprint,&ret))
        vmp::except_s("peer not found");
    return ret;
}

void JrpUI::get_reqdata(vmp::str fingerprint,json::JsonObj *root)
{
    event::Cell *cell=get_cell(fingerprint);
    openssl::jrp::pkg::JrpSslEv *evtssl=cell->event<openssl::jrp::pkg::JrpSslEv>();
    evtssl->reqdata_.root_cpy(root);
}

void JrpUI::recv_abort(event::Cell *cell,json::Json *json)
{
    openssl::jrp::pkg::JrpSslEv *evtssl=cell->event<openssl::jrp::pkg::JrpSslEv>();
    vmp::str msg;
    openssl::jrp::pkg::jrp_abort_get(json,&(evtssl->status_),&msg);
    vmp::unicode::str_write(&(evtssl->msg_),"recv_abort('%s')",msg.c_str());
    manager_->cell_close(cell,event::SUCCESS);   
}

void JrpUI::request_exec()
{
    openssl::jrp::pkg::SrvReq *sreq=0;
    manager_->lock();
    if((requests_ > 0) && (squeue_.size() > 0))
    {
        sreq=squeue_.front();
        squeue_.pop();
        requests_--;
        if(sexec_ == 0)
            sexec_=sreq;
        else
        {
            sreq->next_=sexec_;
            sexec_->prev_=sreq;
            sexec_=sreq;
        }
    }
    manager_->unlock();
    if(sreq != 0)
    {
        peer_->request(this,sreq);
        request_exec();
    }
}

void JrpUI::free_crequest(vmp_int rid)
{
    openssl::jrp::pkg::CltReq *creq;
    try
    {
        cexec_.cancel(rid,&creq);
        creq->reset();
        creqref_.free(creq);
    }
    catch(vmp::exception &x)
    {
    }
}

event::Event *JrpUI::child_event_new(event::Cell *cell)
{
    return (event::Event *) sslref_.get();
}
        
vmp::str JrpUI::identity(event::Cell *cell)
{
    vmp::str ret="";
    openssl::pkg::EventSsl *ssl=cell->event<openssl::pkg::EventSsl>();
    vmp::str type=ssl->evt_ssl_type();
    net::Address *addr;
    if(type == "listen")
    {
        addr=ssl->evt_ssl_localaddr();
        vmp::unicode::str_write(&ret,"Listen(%s,%s)",addr->host().c_str(),addr->service().c_str());
    }
    else
    {
        addr=ssl->evt_ssl_peeraddr();
        vmp::unicode::str_write(&ret,"Peer(%s,%s)",addr->host().c_str(),addr->service().c_str());
    }
    return ret;
}
        
void JrpUI::close_event(event::Cell *cell)
{
    openssl::jrp::pkg::JrpSslEv *evtssl=cell->event<openssl::jrp::pkg::JrpSslEv>();
    evtssl->evt_ssl_close();
}

void JrpUI::free_ref(event::Cell *cell)
{
    openssl::jrp::pkg::JrpSslEv *evtssl=cell->event<openssl::jrp::pkg::JrpSslEv>();
    evtssl->reset();
    evtssl->evt_ssl_free();
    sslref_.free(evtssl);
}

}}}}

