/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 25/06/2022
*/

#ifndef VAMPIRIA_OPENSSL_PKG_JRP_CB_H

#define VAMPIRIA_OPENSSL_PKG_JRP_CB_H 1

namespace vampiria { namespace openssl { namespace jrp { namespace pkg {

//! Internal usage
void ssl_connect(event::Cell *cell);

//! Internal usage
void ssl_accept(event::Cell *cell,event::Cell *child);

//! Internal usage
void ssl_init(event::Cell *cell,vmp::Buf *buf);

//! Internal usage
void ssl_recv(event::Cell *cell,vmp::Buf *buf);

//! Internal usage
void ssl_recv_close(event::Cell *cell,vmp::Buf *buf);

//! Internal usage
void ssl_close(event::Cell *cell);

//! Internal usage
void ssl_close_listen(event::Cell *cell);

//! Internal usage
void timer_ctl(event::Cell *cell);

//! Internal usage
void timer_close(event::Cell *cell);

}}}}

#endif

