/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 20/06/2022
 */
 
#include "openssl2/openssl2.h"

namespace vampiria { namespace openssl { namespace pkg {

Ctx_I::Ctx_I()
{
}

Ctx_I::~Ctx_I()
{
    if(ctx_.ctx_ != 0)
        SSL_CTX_free(ctx_.ctx_);
}

void openssl::pkg::Ctx_I::build_ctx()
{
    if(ctx_.ctx_ == 0)
    {
        ctx_.ctx_=init();
        if(ctx_.ctx_ == 0)
            vmp::except("openssl::pkg::Ctx_I::build_ctx() error %s",openssl::pkg::err_string().c_str());
    }    
}

openssl::pkg::Ctx *Ctx_I::get()
{
    if(ctx_.ctx_ == 0)
        vmp::except_s("openssl::pkg::Ctx_I::get() null context"); 
    return &ctx_;
}

}}}

