/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 07/01/2020
 */

#include "vmp.h"

time_t vmp_time()
{
    return time(0);
}

namespace vampiria { namespace vmp { namespace time {

vmp::time::Timeval timeval_new()
{
    vmp::time::Timeval ret=(vmp::time::Timeval) vmp::malloc_wrap(sizeof(struct timeval));
    ret->tv_sec=0;
    ret->tv_usec=0;
    return ret;
}

vmp::time::Time timeval_to_time(vmp::time::Timeval tval)
{
    vmp::time::Time s=(vmp::time::Time)(tval->tv_sec);
    vmp::time::Time us=((vmp::time::Time)(tval->tv_usec))/1000000;     
    return s+us;
}

vmp::time::Timeval time_to_timeval(vmp::time::Time time)
{
    vmp::time::Timeval ret=0;
    if(time > 0.0)
    {
       ret=timeval_new();
       ret->tv_sec=(time_t) time;
       ret->tv_usec=(suseconds_t) ((time-(time_t)ret->tv_sec) * 1000000);
    }
    return ret;
}

void timeval_free(vmp::time::Timeval *ptval)
{
    vmp::free_wrap((void **)ptval);
}

void vsleep(vmp::time::Time time)
{
    if(time > 0.0)
    {
        vmp_uint sec,msec;
        sec=(vmp_uint) time;
        msec=(vmp_uint)((time - ((vmp::time::Time) sec)) * 1000000);
        sleep_wrap(sec);
        usleep_wrap(msec); 
    }
    
}

vmp_uint time_wrap()
{
    time_t t=vmp_time();
    if(t == -1)
        vmp::except_errno();
    return (vmp_uint) t; 
}

vmp::str ctime_wrap(vmp_uint time)
{
    time_t t;
    if (time == 0)
        t=vmp_time();
    else
        t=(time_t) time;
    vmp::str ret=ctime(&t);
    return ret.substr(0,ret.size()-1);
}

Localtime::Localtime(vmp_uint time)
{
    time_t t;
    if (time == 0)
        t=vmp_time();
    else
        t=(time_t) time;
    if(localtime_r(&t,&tm_) == 0)
        vmp::except_errno();
}

Localtime::~Localtime()
{
}

vmp_uint Localtime::sec()
{
    return (vmp_uint) tm_.tm_sec;
}
        
vmp_uint Localtime::min()
{
    return (vmp_uint) tm_.tm_min;
}

vmp_uint Localtime::hours()
{
    return (vmp_uint) tm_.tm_hour;
}
        
vmp_uint Localtime::mday()
{
    return (vmp_uint) tm_.tm_mday;
}
        
vmp::str Localtime::wday()
{
    switch(tm_.tm_wday)
    {
        case 0:return "Sun";
        case 1:return "Mon";
        case 2:return "Tue";
        case 3:return "Wed";
        case 4:return "Thu";
        case 5:return "Fri";
        case 6:return "Sat";
    }
    return "";
}

vmp_uint Localtime::wday_n()
{
    return (vmp_uint)(tm_.tm_wday)+1;
}
    
vmp::str Localtime::month()
{
    switch(tm_.tm_mon)
    {
        case 0:return "Jan";
        case 1:return "Feb";
        case 2:return "Mar";
        case 3:return "Apr";
        case 4:return "May";
        case 5:return "June";
        case 6:return "July";
        case 7:return "Aug";
        case 8:return "Sept";
        case 9:return "Oct";
        case 10:return "Nov";
        case 11:return "Dec";
    }
    return "";
}

vmp_uint Localtime::month_n()
{
    return (vmp_uint)(tm_.tm_mon)+1;    
}

vmp_uint Localtime::year()
{
    return (vmp_uint) (tm_.tm_year)+1900;
}

Timer::Timer()
{
    init();    
}

Timer::~Timer()
{
}

void Timer::init()
{
    gettimeofday(&tinit_,0);    
}
        
vmp::time::Time Timer::now()
{
    struct timeval now;
    gettimeofday(&now,0);  
    vmp::time::Time s=(vmp::time::Time)(now.tv_sec -tinit_.tv_sec);
    vmp::time::Time us=(((vmp::time::Time)(now.tv_usec))-((vmp::time::Time)(tinit_.tv_usec)))/1000000; 
    return s+us; 
    
}

}}}

