/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 25/01/2020
 */

#ifndef VAMPIRIA_PYLIB_DEF_H

#define VAMPIRIA_PYLIB_DEF_H 1

namespace vampiria { namespace pylib {

struct py_function_impl_base
{
     virtual ~py_function_impl_base(){}
     virtual pylib::Objref *operator()(pylib::Objref *args,pylib::Objref *kw) = 0;
};

template<class Stub_t>
struct py_function_impl:py_function_impl_base
{
    public: 
        py_function_impl(Stub_t const& stub): stub_(stub){}
    
        pylib::Objref *operator()(pylib::Objref *args,pylib::Objref *kw)
        {
             return stub_(args,kw);
        }
    private:
        Stub_t stub_;
};

struct py_function
{
    public:
       template<class Stub_t>
       py_function(Stub_t const &stub):next_(0),impl_(new py_function_impl<Stub_t>(stub)) {}

       pylib::Objref *operator()(pylib::Objref *args,pylib::Objref *kw)
       {
            return (*impl_)(args,kw);
       }

       py_function *next_;
    private:
       mutable vmp::unique_ptr<py_function_impl_base> impl_;
};

struct Def:pylib::Objref
{
    private:
        pylib::py_function *head_;
        pylib::py_function *tail_;
        vmp::str fullname_;
    public:
        Def(pylib::py_function *pf,vmp::str name,pylib::Objbase &base);
        ~Def();

        void insert_py(pylib::py_function *pf);
        pylib::Objref *call(pylib::Objref *args,pylib::Objref *kw); 
};

}}

#endif

