/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 10/10/2020
 */

#ifndef VAMPIRIA_NET_NETDEVICE_H

#define VAMPIRIA_NET_NETDEVICE_H 1

namespace vampiria { namespace net {

//!Get mac address from interface name
/*!
    @param ifname interface name
    @return mac address in string format(except error)
*/
vmp::str iface_mac(vmp::str ifname);

//!Get ipv4 address from interface name
/*!
    @param ifname interface name
    @return ipv4 in string format(except error)
*/
vmp::str iface_ipv4(vmp::str ifname);

//!Get ipv4 netmask from interface name
/*!
    @param ifname interface name
    @return ipv4 netmask in string format(except error)
*/
vmp::str iface_ipv4_netmask(vmp::str ifname);

//!Get ipv4 broadcast from interface name
/*!
    @param ifname interface name
    @return ipv4 broadcast in string format(except error)
*/
vmp::str iface_ipv4_broadcast(vmp::str ifname);

//!Get mtu from interface name
/*!
    @param ifname interface name
    @return mtu(except error)
*/
vmp_uint iface_ipv4_mtu(vmp::str ifname);

}}

#endif

