/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 *Date last update: 10/10/2020
 */

#include "net.h"

namespace vampiria { namespace net {

void get_ioctl_data(vmp::str ifname,vmp_uint request,struct ifreq *ifr)
{
    net::Socket sock=net::socket_datagram(AF_INET,false);
    vmp::ioctl_wrap_ifreq(sock,ifname,request,ifr);
    net::socket_close(&sock);    
}

vmp::str iface_mac(vmp::str ifname)
{
    struct ifreq ifr;
    try
    {
        get_ioctl_data(ifname,SIOCGIFHWADDR,&ifr);
    }
    catch(vmp::exception &x)
    {
        vmp::except("net::iface_mac(%s) '%s'",ifname.c_str(),x.what());
    }
    net::MacAddress m;
    vmp::vector<vmp_byte> v;
    for(vmp_index i=0;i<6;i++)
        v.push_back(ifr.ifr_hwaddr.sa_data[i]);
    m.set(v);
    return m.str_addr();  
}

vmp::str iface_ipv4(vmp::str ifname)
{
    struct ifreq ifr;
    try
    {
         get_ioctl_data(ifname,SIOCGIFADDR,&ifr);
    }
    catch(vmp::exception &x)
    {
         vmp::except("net::iface_ipv4(%s) '%s'",ifname.c_str(),x.what());
    }
    net::Address addr;
    addr.set(&ifr.ifr_addr,sizeof(struct sockaddr_in));
    return addr.ip();
}

vmp::str iface_ipv4_netmask(vmp::str ifname)
{
    struct ifreq ifr;
    try
    {
         get_ioctl_data(ifname,SIOCGIFNETMASK,&ifr);
    }
    catch(vmp::exception &x)
    {
         vmp::except("net::iface_ipv4_netmask(%s) '%s'",ifname.c_str(),x.what());
    }
    net::Address addr;
    addr.set(&ifr.ifr_addr,sizeof(struct sockaddr_in));
    return addr.ip();
}

vmp::str iface_ipv4_broadcast(vmp::str ifname)
{
    struct ifreq ifr;
    try
    {
        get_ioctl_data(ifname,SIOCGIFBRDADDR,&ifr); 
    }
    catch(vmp::exception &x)
    {
        vmp::except("net::iface_ipv4_broadcast(%s) '%s'",ifname.c_str(),x.what());
    }
    net::Address addr;
    addr.set(&ifr.ifr_addr,sizeof(struct sockaddr_in));
    return addr.ip();
}

vmp_uint iface_ipv4_mtu(vmp::str ifname)
{
    struct ifreq ifr;
    try
    {
         get_ioctl_data(ifname,SIOCGIFMTU,&ifr);    
    }
    catch(vmp::exception &x)
    {
         vmp::except("net::iface_ipv4_mtu(%s) '%s'",ifname.c_str(),x.what());
    }
    return ifr.ifr_mtu;
}

}}

