/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 18/09/2022
*/

#ifndef VAMPIRIA_JSON_JAPI_H

#define VAMPIRIA_JSON_JAPI_H 1

namespace vampiria { namespace json {

//! Returns the full name of the data type json(example json::'jtype')
/*!
    @param jtype short name data type json
    @return full name data type json 
*/
vmp::str japi(vmp::str jtype);

//! Returns json type list [subtype] or []
/*!
    @param jtype json type in list("" list not typed)
    @return list type
*/
vmp::str japi_type_list(vmp::str jtype="");

//! Returns json type teble {subtype} or {}
/*!
    @param jtype json type in table("" table not typed)
    @return table type
*/
vmp::str japi_type_table(vmp::str jtype="");

//! Create a json data json::japi("void")
/*!
    <pre>
    { 
       jtype: json::japi("void"),
       jbody: {}
    }
    </pre>
    @param obj object where the json data is inserted
    @return void or except in case of failure
*/
void japi_void(json::JsonObj *obj);

//! Create a json data json::japi("[datatype]") or json::japi("[]") for generic list
/*!
    <pre>
    {
        jtype: json::japi("[datatype]"),
        jbody:
        {
            datatype:'datatype',
            list: 'list'(empty in this case)
        }
    }
    </pre>
    @param obj object where the json data is inserted
    @param datatype jdata types in the list(read data with json::jdata.get_text("datatype"),read data list with json::jdata.get_list("list"))
    @return void or except in case of failure
*/
void japi_list(json::JsonObj *obj,vmp::str datatype="");

//! Create a json data ['datatype'] or "[]" for generic list
/*!
    <pre>
    {
        jtype: [datatype],
        jbody:
        {
            datatype:'datatype',
            list: 'list'
        }
    }
    </pre>
    @param obj object where the json data is inserted
    @param list jdata types in the list(read data list with json::jdata.get_list("list"),read datatype with json::jdata.get_text("datatype"))
    @return void or except in case of failure
*/
void japi_list(json::JsonObj *obj,json::JList *list);

//! Create a json data {'datatype'} or "{}" for generic table
/*!
    <pre>
    {
        jtype: {'datatype'}, 
        jbody:
        {
            datatype:'datatype',
            table:'table'(empty in this case)
        }
    }
    </pre>
    @param obj object where the json data is inserted
    @param datatype jdata types in the table(read data with json::jdata.get_text("datatype"),read data table with json::jdata.get_table("table"))
    @return void or except in case of failure
*/
void japi_table(json::JsonObj *obj,vmp::str datatype="");

//! Create a json data json::japi("{datatype}") or json::japi("{}") for generic table
/*!
    <pre>
    {
        jtype: json::japi({'datatype'}), 
        jbody:
        {
            datatype:'datatype',
            table:'table'
        }
    }
    </pre>
    @param obj object where the json data is inserted
    @param table jdata types in the table(read data table with json::jdata.get_table("table"),read datatype with json::jdata.get_text("datatype"))
    @return void or except in case of failure
*/
void japi_table(json::JsonObj *obj,json::JTable *table);

}}

#endif

