/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 15/05/2020
 */

#include "event.h"

namespace vampiria { namespace event {

InputUI::InputUI(event::Manager *manager):UI(manager)
{
    cell_=0;
    set_event(0,0);
}
        
InputUI::~InputUI()
{
}

vmp::str InputUI::identity(event::Cell *cell)
{
    return "Input event";
}

void InputUI::close_event(event::Cell *cell)
{
    evinput_.evt_input_close();
}
        
void InputUI::free_ref(event::Cell *cell)
{
    evinput_.evt_input_free();
    cell=0;
}

void InputUI::set_event(event::EVTCBSTR ievent,event::EVTCB cevent)
{
    ievent_=ievent;
    cevent_=cevent;
}

Cell *InputUI::input()
{
    manager_->lock();
    if(cell_ != 0)
    {
        manager_->unlock();
        vmp::except_s("event::InputUI::input() requested duplicate cell");
    }
    try
    {
        cell_=evinput_.evt_input_new(this,ievent_,cevent_);
    }
    catch(vmp::exception &x)
    {
        manager_->unlock();
        vmp::except("event::InputUI::input() %s",x.what());
    }
    manager_->unlock();
    return cell_;
}

}}


