/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 10/08/2021
 */

#include "event.h"

namespace vampiria { namespace event {

void cancel_default(event::Cell *cell)
{
    event::Manager *manager=cell->get_manager();
    manager->lock();
    vmp::thread::pthread_cancel_wrap(cell->event<event::EventThread>()->thread_.pth());
    manager->unlock();
}

void close_thread(event::Cell *cell)
{
    event::EventThread *th=cell->event<event::EventThread>();
    event::Manager *manager=cell->get_manager();
    manager->lock();
    if(th->cancel_)
    {
        th->cancel_=false;
        manager->unlock();
        th->thread_.cancel();
        th->thread_.stop();
    }
    else
        manager->unlock();
    th->close_(cell);    
}

ThreadEv::ThreadEv()
{
}
        
ThreadEv::~ThreadEv()
{
}

void ThreadEv::cancel_impl()
{
    cancel_(cell_);
}

void ThreadEv::run()
{
    event::Manager *manager=cell_->get_manager();
    try
    {
        run_(cell_);
    }
    catch(vmp::exception &x)
    {
        manager->lock();
        event_->evt_pipe_closew();
        manager->unlock();
        vmp::except_s(x.what());
    }
    manager->lock();
    event_->evt_pipe_closew();
    manager->unlock();
}

EventThread::EventThread():event::EventPipe()
{
    thread_.event_=this;
}

EventThread::~EventThread()
{
    thread_.event_=0; 
}

void thread_ev(event::Cell *cell)
{
    event::Manager *manager=cell->get_manager();
    EventThread *event=cell->event<EventThread>();
    manager->lock();
    vmp_byte byte;
    try
    {
        if(vmp::fd_read_bytes(event->fd_,&byte,1) == 0)
        {
             if(event->cancel_)
             {
                 event->cancel_=false;
                 event->thread_.stop();
                 manager->cell_close(cell,event::SUCCESS);
             }
        }
    }
    catch(vmp::exception &x)
    {
        manager->cell_close(cell,event::ERROR,x.what());
    }
    manager->unlock();
}

event::Cell *EventThread::evt_thread_new(event::UI *ui,event::EVTCB run,event::EVTCB cancel,event::EVTCB close)
{
    cancel_=false;
    event::Cell *cell;
    try
    {
        cell=evt_pipe_new(ui,thread_ev,close_thread);
    }
    catch(vmp::exception &x)
    {
        vmp::except_s(x.what());
    }
    if(run == 0)
        thread_.run_=event::empty_ev;
    else
        thread_.run_=run;
    if(cancel == 0)
        thread_.cancel_=event::cancel_default;
    else
        thread_.cancel_=cancel;
    if(close == 0)
        close_=event::empty_ev;
    else
        close_=close;
    thread_.cell_=cell;
    event::Manager *manager=cell->get_manager();
    manager->cell_alloc(cell);
    return cell;
}

void EventThread::evt_thread_start()
{
    try
    {
        cancel_=true;
        thread_.start();
    }
    catch(vmp::exception &x)
    {
        cancel_=false;
        cell_->get_manager()->cell_close(cell_,event::ERROR,x.what());
    }
}

void EventThread::evt_thread_close()
{
    evt_pipe_close();
}

void EventThread::evt_thread_free()
{
    event::Manager *manager=cell_->get_manager();
    thread_.cell_=0;
    manager->cell_release(cell_);
    evt_pipe_free();
}

}}

