/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 01/12/2022
 */

#include "xml_.h"

PyTag::PyTag():xml::Tag()
{
}

PyTag::~PyTag()
{
}

void PyTag::build()
{
    pylib::CArgs cargs(0);
    build_.call(cargs);
}

class PyParser:public xml::DomParser
{
    private:
        xml::Tag *create_tag(vmp::str name);
        void destroy_impl();
    public:
        pylib::PyCall defobj_;
        vmp::Table<vmp::str,pylib::PyCall *> typeobj_;
        PyParser();
        ~PyParser();
};

PyParser::PyParser():xml::DomParser()
{
}

PyParser::~PyParser()
{
}

xml::Tag *PyParser::create_tag(vmp::str name)
{
    pylib::PyCall *typeobj;
    if(!typeobj_.search(name,&typeobj))
        typeobj=&defobj_;
    pylib::CArgs cargs(0);
    pylib::PyObj ret=typeobj->call(cargs);
    pylib::PyObj pytag=ret.get_attr("pytag");
    PyTag *tag=pytag.get<PyTag *>();
    return (xml::Tag *) tag;
}

void PyParser::destroy_impl()
{
    vmp::table_delete_alldata<vmp::str,pylib::PyCall *>(typeobj_);
}

struct PyParser_stub_Constructor:public pylib::Constructor<PyParser>
{
    PyParser *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            PyParser *parser=new PyParser();
            try
            {
                 args.get_callable(0,parser->defobj_);
            }
            catch(vmp::invalid_argument &x)
            {
                delete parser;
                args.arg_error();
            }
            catch(vmp::exception &x)
            {
                delete parser;
                vmp::except_s(x.what());
            }
            return parser;
        }
        return 0;
    }
};

struct stub_create_tag:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 2)
         {
             PyTag *pytag=new PyTag();
             try
             {
                 args.get_obj(0,pytag->pyobj_);
                 args.get_callable_member(0,"build",pytag->build_);
                 vmp_uint priority=args.get<vmp_uint>(1);
                 pytag->set_priority(priority);
             }
             catch(vmp::invalid_argument &x)
             {
                 delete pytag;
                 args.arg_error();
             }
             catch(vmp::exception &x)
             {
                 delete pytag;
                 vmp::except_s(x.what());
             }
             return pylib::Converter<PyTag *>(pytag,false);
         }
         return 0;
    }
};

struct stub_pyparser_add_tag:public pylib::Member_def<PyParser>
{
    pylib::Objref *def(PyParser *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 2)
        {
            vmp::str name=args.get<vmp::str>(0);
            pylib::PyCall *pycall=new pylib::PyCall();
            try
            {
                 args.get_callable(1,*pycall);
                 try
                 {
                     instance->typeobj_.insert(name,pycall);
                     return pylib::retnone();
                 }
                 catch(vmp::exception &x)
                 {
                     vmp::except("Insert error key '%s' already",name.c_str());
                 }    
            }
            catch(vmp::invalid_argument &x)
            {
                delete pycall;
                args.arg_error();
            }
            catch(vmp::exception &x)
            {
                delete pycall;
                vmp::except_s(x.what());
            }
        } 
        return 0;
    }
};

struct stub_pyparser_get_root:public pylib::Member_def<PyParser>
{
    pylib::Objref *def(PyParser *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
        {
            PyTag *pytag=(PyTag *)instance->get_root();
            if(pytag == 0)
                return pylib::retnone();
            return pylib::Converter<pylib::Objref *>(pytag->pyobj_.ref(),false); 
        } 
        return 0;
    }
};

struct stub_pyparser_build:public pylib::Member_def<PyParser>
{
    pylib::Objref *def(PyParser *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        vmp::str filexml;
        vmp::str dtd;
        if(args.size() == 1)
        {
            filexml=args.get<vmp::str>(0);
            instance->build(filexml);
            return pylib::retnone();
        }
        else if(args.size() == 2)
        {
            filexml=args.get<vmp::str>(0);
            dtd=args.get<vmp::str>(1);
            instance->build(filexml,dtd);
            return pylib::retnone();
        }
        return 0;
    }
};

struct stub_pyparser_build_from_str:public pylib::Member_def<PyParser>
{
    pylib::Objref *def(PyParser *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        vmp::str xml;
        vmp::str dtd;
        if(args.size() == 1)
        {
            xml=args.get<vmp::str>(0);
            instance->build_from_str(xml);
            return pylib::retnone();
        }
        else if(args.size() == 2)
        {
            xml=args.get<vmp::str>(0);
            dtd=args.get<vmp::str>(1);
            instance->build_from_str(xml,dtd);
            return pylib::retnone();
        }
        return 0;    
    }
};

struct stub_pytag_get_parent:public pylib::Member_def<PyTag>
{
    pylib::Objref *def(PyTag *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 0)
        {
            PyTag *parent=(PyTag *) instance->get_parent();
            if(parent == 0)
               return pylib::retnone();
            return pylib::Converter<pylib::Objref *>(parent->pyobj_.ref(),false); 
        }
        return 0;
    }
};

struct stub_pytag_get_child:public pylib::Member_def<PyTag>
{
    pylib::Objref *def(PyTag *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            vmp_index index=args.get<vmp_index>(0);
            PyTag *child=(PyTag *) instance->get_child(index);
            if(child == 0)
               return pylib::retnone();
            return pylib::Converter<pylib::Objref *>(child->pyobj_.ref(),false); 
        }
        return 0;
    }
};

void xml_init_parser(pylib::Module module)
{
    module.def_with_stub("create_tag",stub_create_tag());
    
    //xml.h
    pylib::Class<PyParser> pyparser=module.class_with_constructor<PyParser>("Parser",PyParser_stub_Constructor());
    pyparser.def_with_stub("add_tag",stub_pyparser_add_tag());
    pyparser.def_with_stub("get_root",stub_pyparser_get_root());
    pyparser.def_with_stub("build",stub_pyparser_build());
    pyparser.def_with_stub("build_from_str",stub_pyparser_build_from_str());
    pyparser.def_("reset",&PyParser::reset);
    pyparser.def_("destroy",&PyParser::destroy);

    //xml.h
    pylib::Class<PyTag> pytag=module.class_no_constructor<PyTag>("Tag");
    pytag.def_("get_filepath",&PyTag::get_filepath);
    pytag.def_("get_line",&PyTag::get_line);
    pytag.def_("get_name",&PyTag::get_name);
    pytag.def_("get_text",&PyTag::get_text);
    pytag.def_("get_attr",&PyTag::get_attr);
    pytag.def_("get_attrs_name",&PyTag::get_attrs_name);
    pytag.def_with_stub("get_parent",stub_pytag_get_parent());
    pytag.def_with_stub("get_child",stub_pytag_get_child());
    pytag.def_("get_child_number",&PyTag::get_child_number);
    pytag.def_("parser_error",&PyTag::parser_error_s);
}

