/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 10/06/2020
 */

#include "net_.h"

void net_init_udp(pylib::Module module)
{
    //net/udp.h
    pylib::Class<net::Udp> udp=module.class_<net::Udp>("Udp");
    udp.def_("reset",&net::Udp::reset);
    udp.def_("socket",&net::Udp::socket);
    udp.def_("block",&net::Udp::block);
    udp.def_("noblock",&net::Udp::noblock);
    udp.def_("set_maxpsize",&net::Udp::set_maxpsize);
    udp.def_("maxpsize",&net::Udp::maxpsize);
    udp.def_("get_local_address",&net::Udp::get_local_address);
    udp.def_("server",&net::Udp::server);
    udp.def_("client4",&net::Udp::client4);
    udp.def_("client6",&net::Udp::client6);
    udp.def_("sentTo",&net::Udp::sendTo);
    udp.def_("recvFrom",&net::Udp::recvFrom);
    udp.def_("close",&net::Udp::close);
}

class PyUdpUI:public net::UdpUI
{
   public:
        PyUdpUI(event::Manager *manager);
        ~PyUdpUI();

        pylib::PyCall pyrevent_;
        pylib::PyCall pycevent_;
};

PyUdpUI::PyUdpUI(event::Manager *manager):net::UdpUI(manager)
{
}

PyUdpUI::~PyUdpUI()
{
}

struct stub_udpui:public pylib::Generic_def
{
    pylib::Objref *def(pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if(args.size() == 1)
        {
            event::Cell *cell=args.get<event::Cell *>(0);
            return pylib::Converter<PyUdpUI *>(cell->ui<PyUdpUI>(),false);

        }
        return 0;
    }
};

struct UdpUI_Constructor:public pylib::Constructor<PyUdpUI>
{
    PyUdpUI *build_instance(pylib::Args &args,pylib::KwArgs &kwargs)
    {
         if(args.size() == 1)
         {
              event::Manager *manager=args.get<event::Manager *>(0);
              return new PyUdpUI(manager);
         }
         return 0;
    }
};

void udp_pyrevent(event::Cell *cell,vmp::Buf *buf,net::Address *peer)
{
    PyUdpUI *udpui=cell->ui<PyUdpUI>();
    pylib::CArgs cargs(3);
    cargs.add<event::Cell *>(cell,false);
    cargs.add<vmp::Buf *>(buf,false);
    cargs.add<net::Address *>(peer,false);
    udpui->pyrevent_.call(cargs);
}

void udp_pycevent(event::Cell *cell)
{
    PyUdpUI *udpui=cell->ui<PyUdpUI>();
    pylib::CArgs cargs(1);
    cargs.add<event::Cell *>(cell,false);
    udpui->pycevent_.call(cargs);
}

struct stub_UdpUI_set_event:public pylib::Member_def<PyUdpUI>
{
    pylib::Objref *def(PyUdpUI *instance,pylib::Args &args,pylib::KwArgs &kwargs)
    {
        if((args.size() == 2) || (args.size() == 3))
        {
            net::EVTCBRECVFROM revent;
            event::EVTCB cevent;
            
            args.get_callable(0,instance->pyrevent_);
            args.get_callable(1,instance->pycevent_);
            
            if(pylib::is_none(instance->pyrevent_.ref()))
                revent=0;
            else 
                revent=udp_pyrevent;
            if(pylib::is_none(instance->pycevent_.ref()))
                cevent=0;
            else 
                cevent=udp_pycevent;
            if(args.size() == 2)
                instance->set_event(revent,cevent);
            else
            {
                vmp_size size=args.get<vmp_size>(2);
                instance->set_event(revent,cevent,size);
            }
            return pylib::retnone();                      
        }
        return 0;
    }
};

void net_init_udpui(pylib::Module module)
{
    //Wrapper cell->ui()
    module.def_with_stub("udpui",stub_udpui());

    //net/udp.h
    pylib::Class<PyUdpUI> udpui=module.class_with_constructor<PyUdpUI>("UdpUI",UdpUI_Constructor());
    udpui.def_with_stub("set_event",stub_UdpUI_set_event());
    udpui.def_("new_server",&PyUdpUI::new_server,false);
    udpui.def_("new_client4",&PyUdpUI::new_client4,false);
    udpui.def_("new_client6",&PyUdpUI::new_client6,false);
    udpui.def_("sendTo",&PyUdpUI::sendTo);
    udpui.def_("maxpsize",&PyUdpUI::maxpsize);
    udpui.def_("localaddr",&PyUdpUI::localaddr,false);
}


