#!/usr/bin/python

#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License version 3 as
#published by the Free Software Foundation;

#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Author: Marco Guastella alias Vasta
#Web page:<www.ragnu.it>
#Email: <vasta@ragnu.it>
#Date last Update : 29/09/2022

import vmplib    as lib
import vmppylib  as pylib
import vmpsys    as sys
import vmpconfig as config

lib.included_.append(sys.path(config.gpkg_))

xterm0=lib.clib()
xterm0.name='xterm0'
xterm0.dependencies=['vmp']
xterm0.pkg=True
xterm0.files=[('xterm/',['xterm'])]
xterm0.cmd=['xterm -h']
lib.clibs_[xterm0.name]=xterm0

rawnet2=lib.clib()
rawnet2.name='rawnet2'
rawnet2.dependencies=['vmp','packet','event','net']
rawnet2.pkg=True
rawnet2.files=[('rawnet/',['arpui','lib','rawnet','rawevent','rawui'])]
rawnet2.libs=[('libpcap','1.10.0')]
rawnet2.coptions=['`pkg-config --cflags libpcap`']
rawnet2.loptions=['`pkg-config --libs  libpcap`']
lib.clibs_[rawnet2.name]=rawnet2

openssl2=lib.clib()
openssl2.name='openssl2'
openssl2.dependencies=['vmp','net','event','json']
openssl2.pkg=True
openssl2.cmd=['openssl version','chmod --version','cp --version']
openssl2.files=[('openssl/',['lib','hash','openssl','x509','pkey','sslevent','sslui']),('openssl/ctx/',['ctx','base','peer']),('openssl/jrp/',['lib','jrp','cb','internal'])]
openssl2.libs=[('openssl','1.1.1k')]
openssl2.loptions=['`pkg-config --libs  openssl`']
lib.clibs_[openssl2.name]=openssl2

vmp_xterm0=pylib.pylib()
vmp_xterm0.name='vmp_xterm0'
vmp_xterm0.dependencies=[]
vmp_xterm0.pkg=True
vmp_xterm0.cbuild()
vmp_xterm0.setup.files=[('./',['xterm_'])]
vmp_xterm0.setup.dependencies=['pylib','xterm0','vmp']
pylib.pylibs_[vmp_xterm0.name]=vmp_xterm0

vmp_gui0=pylib.pylib()
vmp_gui0.name='vmp_gui0'
vmp_gui0.dependencies=[]
vmp_gui0.pkg=True
pylib.pylibs_[vmp_gui0.name]=vmp_gui0

vmp_openssl2=pylib.pylib()
vmp_openssl2.name='vmp_openssl2'
vmp_openssl2.dependencies=['vmp','vmp_net','vmp_event']
vmp_openssl2.pkg=True
vmp_openssl2.cbuild()
vmp_openssl2.setup.files=[('./',['openssl_','hash_','pkey_','x509_','sslui_','ctx_','jrp_'])]
vmp_openssl2.setup.dependencies=['pylib','openssl2']
pylib.pylibs_[vmp_openssl2.name]=vmp_openssl2

vmp_rawnet2=pylib.pylib()
vmp_rawnet2.name='vmp_rawnet2'
vmp_rawnet2.dependencies=['vmp','vmp_event','vmp_packet']
vmp_rawnet2.pkg=True
vmp_rawnet2.cbuild()
vmp_rawnet2.setup.files=[('./',['arpui_','rawnet_','rawui_'])]
vmp_rawnet2.setup.dependencies=['pylib','rawnet2']
pylib.pylibs_[vmp_rawnet2.name]=vmp_rawnet2

