/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
 * Date last update: 01/07/2022
 */
 
#include "pylib.h"
#include "openssl2/openssl2.h"

#ifndef VAMPIRIA_PY_OPENSSL_H

#define VAMPIRIA_PY_OPENSSL_H 1

//!Python wrapper of the c++ namespace vampiria::openssl::pkg in vmp_openssl{version}.(see c++ doc)
/*!
    Function c++ openssl{version}/openssl{version}.h(pkg):<BR>init(),end()
*/
/*!
    Context class in openssl{version}/openssl{version}.h(pkg):<BR>No Constructor<BR>
*/
/*!
    SslClient class in openssl{version}/openssl{version}.h(pkg):<BR>Constructor SslClient(Ctx)<BR>
    SslClient member function list:<BR>reset(),socket(),block(),noblock(),type(),get_local_address(),get_peer_address(),
                                       sendData(),recvData(),key_update(),get_peer_cerificate(),close(),
                                       connect(),connect_check(),ssl_connect()
*/
/*!
    SslServer class in openssl{version}/openssl{version}.h(pkg):<BR>no constructor<BR>
    SslServer member function list:<BR>reset(),socket(),block(),noblock(),type(),get_local_address(),get_peer_address(),
                                       sendData(),recvData(),key_update(),get_peer_cerificate(),close(),
                                       ssl_accept()
*/
/*!
    SslListen class in openssl{version}/openssl{version}.h(pkg):<BR>Constructor SslListen(Ctx)<BR>
    SslListen member function list:<BR>reset(),socket(),block(),noblock(),type(),get_local_address(),close(),
                                                              server(),accept()
*/
void openssl_init(pylib::Module module);

//!Python wrapper of the c++ namespace vampiria::openssl::pkg in vmp_openssl{version}.(see c++ doc)
/*!
    Function c++ openssl{version}/openssl/hash.h(pkg):<BR>md5(),sha1(),sha224(),sha256(),sha384(),sha512()
*/
void openssl_hash(pylib::Module module);

//!Python wrapper of the c++ class vampiria::openssl::pkg::PKey in vmp_openssl{version}.PKey(see c++ doc)
/*!
    PKey class in openssl{version}/pkey.h(pkg):<BR>Constructor PKey()<BR>
    PKey member function list:<BR>reset(),key_print(),type_str()
*/
void openssl_pkey(pylib::Module module);

//!Python wrapper of the c++ class vampiria::openssl::pkg::X509_Wrap in vmp_openssl{version}.X509_Wrap(see c++ doc)
/*!
    X509_Wrap class in openssl{version}/openssl/x509.h.h(pkg):<BR>Constructor X509_Wrap()<BR>
    X509_Wrap member function list:<BR>reset(),set_from_file(),parent(),version(),serial(),signature_info(),issuer(),validity_before(),
                                       validity_after(),subject(),pubkey(),id_issuer(),id_subject(),extensions(),
                                       signature_data(),fingerprint_sha1(),fingerprint_sha256(),verify()
*/
void openssl_x509(pylib::Module module);

//!Python wrapper of the c++ class vampiria::openssl::pkg::SslUI in vmp_openssl{version}.SslUI(see c++ doc)
/*!
    Wrapper Cell->ui() for ssl in sslui(cell)<BR>
    @return user interface ssl ui for cell.(The cell must be built with the SslUI user interface)
*/
/*!
    SslUI class in openssl{version}/openssl/sslui.h(pkg):<BR>Constructor SslUI(manager)<BR>
    SslUI member function list:<BR>set_event_client(),set_event_server(),new_client(),new_server(),send(),localaddr(),peeraddr(),
                                   ssl()
    
*/
void openssl_sslui(pylib::Module module);

//!Python wrapper of the c++ class vampiria::openssl::pkg::{Context class} in vmp_openssl{version}.{Context Class}(see c++ doc)
/*!
    Ctx_Base_Tls_Client class in openssl{version}/openssl/ctx/base.h(pkg):<BR>Constructor Ctx_Base_Tls_Client()<BR>
    Ctx_Base_Tls_Client function list:get()
*/
/*!
    Ctx_Base_Tls_Server class in openssl{version}/openssl/ctx/base.h(pkg):<BR>Constructor Ctx_Base_Tls_Server(pkey,x509)<BR>
    Ctx_Base_Tls_Server function list:get(),get_x509
*/
/*!
    Ctx_Peer_Acl class in openssl{version}/openssl/ctx/peer.h(pkg):<BR>Constructor Ctx_Peer_Acl()<BR>
    Ctx_Peer_Acl function list:fingerprint(),subject(),permits()<BR>
*/
/*!
    Ctx_Peer_Tls class in openssl{version}/openssl/ctx/peer.h(pkg):<BR>Constructor Ctx_Peer_Tls(dircert,defp,subject,days=365000)<BR>
    Ctx_Peer_Tls function list:get(),get_x509(),subject(),fingerprint(),defp(),add_acl_peer(),del_acl_peer(),fingerprints_acl_peer(),
                                     get_acl_subject(),verify_acl_peer(),verify_peer(),print_acl()
*/
void openssl_ctx(pylib::Module module);

//!Python wrapper of the c++ namespace vampiria::openssl::jrp::pkg in vmp_openssl{version}.jrp.(see c++ doc)
/*!
    Const c++ error in openssl{version}/jrp/jrp.h(pkg):<BR>status_ok,status_err,status_malformed_msg,status_undef_datatype,
                                                            status_accessdenied,status_duplexsession,status_protocolbad,
                                                            status_closeconnection,status_timeout,status_killed,status_input_bad,
                                                            status_input_notmanaged
    
*/
/*!
    Function c++ in openssl{version}/jrp/jrp.h(pkg):<BR>msg_status()
*/
/*!
    SrvReq class in openssl{version}/jrp/jrp.h(pkg):<BR>No Constructor<BR>
    SrvReq member function list:<BR>set_status(),input(),rid(),fingerprint(),status(),msg(),get_register()
*/
/*!
    CltReq class in openssl{version}/jrp/jrp.h(pkg):<BR>No Constructor<BR>
    CltReq member function list:<BR>input(),rid(),fingerprint(),status(),msg()
*/
/*!
    Peer class in openssl{version}/jrp/jrp.h(pkg):<BR>Constructor Peer(pylib::Objref *)-- input arguments derived class python<BR>
    Peer member function list:<BR>add_reqdata(),reqdata()
*/
/*!
    JrpUI class in openssl{version}/jrp/jrp.h(pkg):<BR>JrpUI(event.manager,openssl.Ctx_Peer_Tls,peer[interface peer class],vmp.utils.Logger,maxrequests=0,ctimeout=3.0)<BR>
    JrpUI member function list:<BR>ctx(),logger(),peer_subject(),peer_permits(),search_peer(),search_input(),search_outputs(),
                                   new_client(),new_listen(),register_event(),abort(),request(),kill(),crequests_size(),
                                   search_crequest(),response(),
*/
void openssl_jrp(pylib::Module module);

#endif


