/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 18/03/2020
 */

#include "tag_env_.h"
#include "tag_std_.h"
#include "tag_module_.h"

#ifndef VAMPIRIA_SOFTWARE_TAG_H

#define VAMPIRIA_SOFTWARE_TAG_H 1

class VampiriaTag:public xml::Tag
{
    public:
        VampiriaTag();
        ~VampiriaTag();

        void build();
};

class ProcessTag:public xml::Tag
{
    private:
        void destroy_impl();
    public:
        ProcessTag();
        ~ProcessTag();

        vmp::Table<vmp::str,ProcessoutTag *> pout_;
        Process *process_;
        vmp::Table<vmp::str,PutenvTag *>  putenv_;
        vmp::Table<vmp::str,PreloadTag *> preload_;
        void build();
};
        
#endif

