/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 18/03/2020
 */

#include "xterm0/xterm0.h"

namespace vampiria { namespace xterm { namespace pkg {

vmp::str shell_(vmp::str title)
{
   vmp::str ret;
   vmp::unicode::str_write(&ret,"xterm -T \"%s\" -e /bin/bash -l -c",title.c_str());
   return ret;
}
vmp::str endcmd_="echo 'digit ^D to exit';while read -r LINE;do if [ -z \"$LINE\" ];then continue;fi;if [ \"$LINE\" = \"^D\" ];then break;fi;done;";


void shell(vmp::str cmd,vmp::str title)
{
   vmp::str command;
   if(cmd[cmd.size()-1] != ';')
       vmp::unicode::str_cwrite(&cmd,";");   
   vmp::unicode::str_write(&command,"%s \"%s%s\"",shell_(title).c_str(),cmd.c_str(),endcmd_.c_str());   
   try
   {
       vmp::system_wrap(command);
   }
   catch(vmp::exception &x)
   {
       vmp::except("Xterm error '%s'",x.what());
   }
}

}}}

