/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 10/08/2021
 */

#ifndef VAMPIRIA_RAWNET_PKG_RAWUI_H

#define VAMPIRIA_RAWNET_PKG_RAWUI_H 1

namespace vampiria { namespace rawnet { namespace pkg {

//! User interface rawnet event
class RawNetUI:public event::UI
{
    private:
        vmp::utils::Storage<rawnet::pkg::EventRawNet> rref_;/*!<Storage event*/
        net::EVTCBRECV recv_;/*!Callback read*/
        event::EVTCB cevent_;/*!Callback Close Event*/
    public:
       //!A Constructor
       /*!
            @param manager input manager
       */
       RawNetUI(event::Manager *manager);
       
       //!A Destructor
       ~RawNetUI();

       //!Virtual class implemented
       vmp::str identity(event::Cell *cell);
       
       //!Virtual class implemented
       void close_event(event::Cell *cell);
       
       //!Virtual class implemented
       void free_ref(event::Cell *cell);

       //!Set callback event
       /*!
            @param recv recv callback
            @param cevent close callback 
       */
       void set_event(net::EVTCBRECV recv,event::EVTCB cevent);

       //! Add read and write raw event(Use start_read() after cell initialization to start the read loop)
       /*!
           @param ifname input interface
           @param filter libpcap filter
           @return event cell ok,otherwise throw exception
       */
       event::Cell *new_rawnet(vmp::str ifname,vmp::str filter);

       //!Add only write raw event
       /*!
          @param iface input interface
          @return event cell ok,otherwise throw exception
       */
       event::Cell *new_rawnet_w(vmp::str ifname);

       //! Starting reading loop(only readwrite mode)
       /*!
           @param cell event cell
       */
       void start_read(event::Cell *cell);

       //!Inject packet
       /*!
           @param cell event cell
           @param buf  buffer to inject
           @return (except error)
       */
       void inject(event::Cell *cell,vmp::Buf *buf);

       //!Get input interface from event
       /*!
           @param cell event cell
           @return input interface
       */
       vmp::str ifname(event::Cell *cell);

       //! Get rawr read filter(libpcap filter)
       /*!
           @param cell event cell
           @return if in readwrite mode return filte,,otherwise throw exception
       */
       vmp::str filter(event::Cell *cell);

       //! It tells us if the event is in write mode or read and write mode
       /*!
            @param cell event cell
            @return "readwrite" or "writeonly"
       */
       vmp::str mode(event::Cell *cell);

       //! Returns linktype in interger format of the event
       /*!
            @param cell event cell
            @return link type
       */
       vmp_int linktype(event::Cell *cell);

       //! Returns linktype in string format of the event
       /*!
            @param cell event cell
            @return link type
       */
       vmp::str linktype_str(event::Cell *cell);     
};

}}}

#endif

