/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 23/06/2022
*/

#ifndef VAMPIRIA_OPENSSL_PKG_JRP_LIB_H

#define VAMPIRIA_OPENSSL_PKG_JRP_LIB_H 1

namespace vampiria { namespace openssl { namespace jrp { namespace pkg {

//! Internal Usage
vmp_int jrp_parse(vmp::Buf *buf,json::Json *json,vmp::str *msgtype);

//! Internal Usage
void jrp_session(vmp::Buf *buf,json::Json *reqdata);

//! Internal Usage
void jrp_session_get(json::Json *json,json::JsonObj *reqdata);

//! Internal Usage
void jrp_abort(vmp::Buf *buf,vmp_int status,vmp::str msg="");

//! Internal Usage
void jrp_abort_get(json::Json *json,vmp_int *status,vmp::str *msg);

//! Internal Usage
void jrp_request(vmp::Buf *buf,vmp_int rid,json::JsonObj *input);

//! Internal Usage
vmp_int jrp_request_get(json::Json *json,json::JsonObj *input);

//! Internal Usage
void jrp_response(vmp::Buf *buf,vmp_int rid,json::JsonObj *outputs);

//! Internal Usage
vmp_int jrp_response_get(json::Json *json,json::JsonObj *outputs);

//! Internal Usage
void jrp_close(vmp::Buf *buf,vmp_int rid,vmp_int status,vmp::str msg="");

//! Internal Usage
vmp_int jrp_close_get(json::Json *json,vmp_int *status,vmp::str *msg);

//! Internal Usage
void jrp_kill(vmp::Buf *buf,vmp_int rid);

//! Internal Usage
vmp_int jrp_kill_get(json::Json *json);

//! Internal Usage
void jrp_ping(vmp::Buf *buf);

//! Internal Usage
void jrp_pong(vmp::Buf *buf);

}}}}

#endif

