/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 20/06/2022
 */
 
#include "openssl2/openssl2.h"

namespace vampiria { namespace openssl { namespace pkg {

Ctx_Base_Tls_Client::Ctx_Base_Tls_Client():Ctx_I()
{
    build_ctx();
}

Ctx_Base_Tls_Client::~Ctx_Base_Tls_Client()
{
}

SSL_CTX *Ctx_Base_Tls_Client::init()
{
    return SSL_CTX_new(TLS_client_method());
}

Ctx_Base_Tls_Server::Ctx_Base_Tls_Server(vmp::str pkey,vmp::str x509):Ctx_I()
{
    pkey_=pkey;
    x509_=x509;
    build_ctx();
}

Ctx_Base_Tls_Server::~Ctx_Base_Tls_Server()
{
}

SSL_CTX *Ctx_Base_Tls_Server::init()
{
    SSL_CTX *ctx=SSL_CTX_new(TLS_server_method());
    if((SSL_CTX_use_PrivateKey_file(ctx,pkey_.c_str(),SSL_FILETYPE_PEM) <= 0) || (SSL_CTX_use_certificate_file(ctx,x509_.c_str(),SSL_FILETYPE_PEM) <= 0))
    {    
        SSL_CTX_free(ctx);
        vmp::except("openssl::pkg::Ctx_Base_Tls_Server::init() error '%s'",openssl::pkg::err_string().c_str());
        return 0;
    }
    return ctx;
}

void Ctx_Base_Tls_Server::get_x509(openssl::pkg::X509_Wrap *x509)
{
    vmp::except_check_pointer((void *) x509,"openssl::pkg::Ctx_Base_Tls_Server::get_x509() null input");
    x509->set(SSL_CTX_get0_certificate(ctx_.ctx_));
}

}}}

