/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 07/01/2020
 */

#include <time.h>
#include <sys/time.h>

#ifndef VAMPIRIA_VMP_TIME_H

#define VAMPIRIA_VMP_TIME_H 1

namespace vampiria { namespace vmp { namespace time {

//!time base type(s.ms)
typedef vmp_real Time;

//! timeval type
typedef struct timeval *Timeval;

//! Alloc Timeval
/*!
    @return timeval struct
*/
vmp::time::Timeval timeval_new();

//!Convert the timeval format Time
/*!
    @param tval input timeval time
    \return time 
*/
vmp::time::Time timeval_to_time(vmp::time::Timeval tval);

//!Convert the Time format timeval(new dynamic timeval struct is allocated)
/*!
     @param time input time
     @return timeval converterd
*/
vmp::time::Timeval time_to_timeval(vmp::time::Time time);

//! Free Timeval struct and settin (*pval) = 0
/*!
    @param ptval pointer to timeval
*/
void timeval_free(vmp::time::Timeval *ptval);

//!Causes the calling thread to sleep for time
/*!
    @param time time to sleep thread
*/
void vsleep(vmp::time::Time time);

//!Returns the time as the number of seconds since the Epoch,1970-01-01 00:00:00 +0000 (UTC).
/*!
    return time,except error
*/
vmp_uint time_wrap();

//!Returns the current time in string format
/*!
    @param time the number of seconds since the Epoch,1970-01-01 00:00:00 +0000 (UTC).if time=0 use present time
    @return current time string
*/
vmp::str ctime_wrap(vmp_uint time=0);

//!Represents local calendar time
class Localtime
{
    private:
        struct tm tm_;
    public:
        //! A constructor
        /*!
            @param time the number of seconds since the Epoch,1970-01-01 00:00:00 +0000 (UTC).if time=0 use present time
        */
        Localtime(vmp_uint time=0);

        //! A destructor
        ~Localtime();

        //! Returns the number of seconds after the minute, in the range 0 to 59.        
        vmp_uint sec();

        //! Returns the number of minutes after the hour, in the range 0 to 59.    
        vmp_uint min();

        //! Returns the number of hours past midnight, in the range 0 to 23.
        vmp_uint hours();

        //! Returns the day of the month, in the range 1 to 31
        vmp_uint mday();
        
        //! Returns days of the week in abbreviated form(Sun,Mon,Tue,Wed,Thu,Fri,Sat)
        vmp::str wday();
        
        //! Returns the number of days since Sunday, in the range 1 to 7
        vmp_uint wday_n();

        //! Returns the month in the short form(Jan,Feb,Mar,Apr,May,June,July,Aug,Sept,Oct,Nov,Dec)
        vmp::str month();

        //! Returns The number of months since January, in the range 1 to 12
        vmp_uint month_n();

        //! The number of years
        vmp_uint year();
        
};

//!Timer object utility
class Timer
{
    private:
        struct timeval tinit_;/*!< Init time*/    
    public:    
        //! A constructor        
        Timer();

        //! A destructor
        ~Timer();
        
        //!Set the initial time reference to the current time
        /*!
            @sa tinit_
        */
        void init();
        
        //! Returns the current time than the time init
        /*!
            @sa tinit_             
            @return current time
        */
        vmp::time::Time now();
};

}}}

#endif

