/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 23/01/2020
 */
 
 #ifndef VAMPIRIA_PYLIB_PYBASE_H

#define VAMPIRIA_PYLIB_PYBASE_H 1

namespace vampiria { namespace pylib {

//! Increment references count input python object
/*!
    @param incref object input
*/
void incref(pylib::Objref *ref);

//! Decrement references count input python object
/*!
    @param incref object input
*/
void decref(pylib::Objref *ref);

pylib::Objref *none();

vmp_bool is_none(pylib::Objref *ref);
vmp_bool is_null(pylib::Objref *ref);

void pyerr_clear();

vmp::str pyunicode_asstring(pylib::Objref *obj);
vmp_char pychar_aschar(pylib::Objref *obj);
vmp_uchar pychar_asuchar(pylib::Objref *obj);
vmp_int  pylong_aslong(pylib::Objref *obj);
vmp_uint pylong_asulong(pylib::Objref *obj);
vmp_int16 pylong_asint16(pylib::Objref *obj);
vmp_uint16 pylong_asuint16(pylib::Objref *obj);
vmp_bool pylong_asbool(pylib::Objref *obj);
vmp_real pyfloat_asreal(pylib::Objref *obj);

pylib::Objref *pyunicode_decode(vmp::str str);

void pyerr_occurred();

void pyobj_delattr(pylib::Objref *obj,vmp::str name);

template<typename T>	
void pyobj_setattr(pylib::Objref *obj,vmp::str name,T value)
{
    pylib::Objref *ovalue=pylib::Converter<T>(value);
    pylib::incref(ovalue);
    if(PyObject_SetAttrString(obj,name.c_str(),ovalue) == -1)
    {    
        pylib::decref(ovalue);
        pylib::pyerr_clear();
        vmp::except("pyobj_setattr error insert '%s' value",name.c_str());
    }
}

pylib::Objref *pyobj_getattr_obj(pylib::Objref *obj,vmp::str name);

template<typename T>
T pyobj_getattr(pylib::Objref *obj,vmp::str name)
{
    pylib::Objref *ref=PyObject_GetAttrString(obj,name.c_str());
    if(ref == 0)
    {
        pylib::pyerr_clear();
        vmp::except("pyobj_getattr error get value '%s' not found ",name.c_str());
    }
    return pylib::arg_from_python<T>(ref);
}

void pymodule_addobj(pylib::Objref *module,vmp::str name,pylib::Objref *value);

pylib::Objref *pymodule_init(vmp::str name);
	
pylib::Objref *pymodule_addsubmodule(pylib::Objref *module,vmp::str name,vmp::str prefix);

//list
pylib::Objref *pylist_new(vmp_size size);
vmp_bool pylist_check(pylib::Objref *list);
vmp_size pylist_size(pylib::Objref *list);
pylib::Objref *pylist_getitem(pylib::Objref *obj,vmp_index pos);

template<typename T>
void pylist_setitem(pylib::Objref *list,vmp_index pos,T value,vmp_bool retfree=true)
{
    if(!pylist_check(list))
        vmp::except_s("pylist_setitem error input objref not list type");
    try
    {
        pylib::Objref *ovalue=pylib::Converter<T>(value,retfree);
        pylib::incref(ovalue);
        if(PyList_SetItem(list,pos,ovalue) == -1)
        {
            pylib::decref(ovalue);
            pylib::pyerr_clear();
            vmp::except("error set objref index %d",pos);
        }
    }
    catch(vmp::exception &x)
    {
        vmp::except("pylist_setitem %s",x.what());
    }
}

void pylist_clear(pylib::Objref *list);
pylib::Objref *pylist_astuple(pylib::Objref *list);

//tuple
vmp_bool pytuple_check(pylib::Objref *tuple);
vmp_size pytuple_size(pylib::Objref *tuple);
pylib::Objref *pytuple_getitem(pylib::Objref *tuple,vmp_size pos);

//dictionary
pylib::Objref *pydict_new();
vmp_bool pydict_check(pylib::Objref *dict);
vmp_bool pydict_next(pylib::Objref *dict,Py_ssize_t *ppos,pylib::Objref **pkey,pylib::Objref **pvalue);
void pydict_setitem(pylib::Objref *dict,pylib::Objref *key,pylib::Objref *val);
void pydict_clear(pylib::Objref *dict);

template<typename Key,typename Data>
void pydict_setitem(pylib::Objref *dict,Key key,Data data,vmp_bool kretfree=true,vmp_bool dretfree=true)
{
   if(!pydict_check(dict))
       vmp::except_s("pydict_setitem error input objref not dict type");
   try
   {
       pylib::Objref *kvalue=pylib::Converter<Key>(key,kretfree);
       pylib::incref(kvalue);
       pylib::Objref *ovalue=pylib::Converter<Data>(data,dretfree);
       pylib::incref(ovalue);
       if(PyDict_SetItem(dict,kvalue,ovalue) == -1)
       {
           pylib::decref(kvalue);
           pylib::decref(ovalue);
           pylib::pyerr_clear();
           vmp::except_s("error set item value"); 
       }
   }
   catch(vmp::exception &x)
   {
       vmp::except("pydict_setitem %s",x.what());
   }
}

void pydict_clear(pylib::Objref *dict);

vmp_bool pycallable_check(pylib::Objref *callable);
pylib::Objref *pycallable_call(pylib::Objref *callable,pylib::Objref *tuple);

}}

#endif


 
 
