/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 13/02/2020
 */

#ifndef VAMPIRIA_PROCESS_EXEC_H

#define VAMPIRIA_PROCESS_EXEC_H 1

namespace vampiria { namespace process {

//!Executes the program filename. This causes the program that is currently being run by the calling process  to  be  re‐placed  with  a new program,with newly initialized stack, heap, and (initialized and uninitialized) data segments.
/*!
    @param filename binary executable
    @param argv an vector of argument strings passed to the new program
    @param envp environment to the new program
    @return void (except error)
*/
void exec(vmp::str filename,vmp::vector<vmp::str> args,vmp::args::Envp &env);

//! Python Input utility(internal use)
class PyInput
{
    private:
        vmp::vector<vmp::str> args_; /*!<Python input arguments list*/
        vmp::vector<vmp::str> vargs_;/*!<Python input variable arguments*/
    public:
        //! A constructor
        /*!
            @param args  input arguments list
            @param vargs input variable arguments
        */
        PyInput(vmp::vector<vmp::str> args,vmp::vector<vmp::str> vargs);

        //! A destructor        
        ~PyInput();

        //!Transform the arguments and argument variables of an input into the string format to be given as input to the execution of the python process
        /*!
            @return Args in string format
        */
        vmp::str get_pytuple();
};

//! Utility to run a vampiria python process
class Pyexec
{
    private:
        vmp::str dirpath_;/*!<Directory path where main.py is located*/
        vmp::str id_;     /*!<Python process id*/
        vmp::str debug_;  /*!<Exec in debug mode?*/
        vmp::MTable<vmp::str,process::PyInput> input_;/*!<Multi table for input data*/
        vmp::args::Envp envp_;/*! Enviroment variable to new python program*/
    public:
        //! A constructor
        /*!
            @param dirpath Directory path where main.py is located
            @param id Python process id
            @param debug Exec in debug mode?
            @param envp Enviroment variable to new python program
        */
        Pyexec(vmp::str dirpath,vmp::str id,vmp_bool debug,vmp::args::Envp &envp);
        
        //! Add destructor
        ~Pyexec();
      
        //! Add an input in python program
        /*!
            @param name input name
            @param args input arguments list
            @param vargs Python input variable arguments
        */
        void add_input(vmp::str name,vmp::vector<vmp::str> args,vmp::vector<vmp::str> vargs);
        
        //!Return the string representing the input arguments of the python program
        /*!
             @return dictyonary python in string format
        */
        vmp::str get_pydict();

        //!Executes the program python
        void run();  
};

}}

#endif

