/* -*- Mode:C++; c++-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella alias Vasta 
 * Web page:<www.ragnu.it> 
 * Email:<vasta@ragnu.it>
   Date last update: 06/04/2022
*/

#include "json.h"

namespace vampiria { namespace json {

JTable::JTable()
{
    table_=0;
    jtype_="";
}

JTable::~JTable()
{
    reset();
}

void JTable::check_init(vmp::str fname)
{
    if(table_ == 0)
        vmp::except("json::JTable::%s() table json obj not setting",fname.c_str());
}

void JTable::reset()
{
    if(table_ != 0)
        delete table_;
    table_=0;
    jtype_="";
}

void JTable::set(json::JsonObj *table,vmp::str jtype)
{
    vmp::except_check_pointer((void *) table,"json::JTable::set() null input pointer table");
    json::JsonObj obj;
    json::JData tmp;
    try
    {
        vmp::vector<vmp::str> keys=table->keys();
        for(vmp_index i=0;i<keys.size();i++)
        {
            table->get_object(keys[i],&obj);
            tmp.set(&obj);
            if((jtype != "") && (tmp.jtype() != jtype))
                vmp::except_s("");
        }
        reset();
        table_=table;
        jtype_=jtype;
    }
    catch(vmp::exception &x)
    {
        vmp::except_s("json::JTable::set() input table bad object");
    }
}

json::JsonObj *JTable::table()
{
    check_init("table");
    return table_;
}

vmp::str JTable::jdata_type()
{
    check_init("jdata_type");
    return jtype_;
}

vmp::vector<vmp::str> JTable::keys()
{
    check_init("keys");
    return table_->keys();
}

void JTable::insert(vmp::str jkey,json::JsonObj *jdata)
{
    check_init("insert");
    vmp::except_check_pointer((void *) jdata,"json::JTable::insert() null input pointer jdata");
    try
    {
        json::JData tmp;
        tmp.set(jdata);
        if((jtype_ != "") && (tmp.jtype() != jtype_))
            vmp::except_s("");
        table_->add_object_ex(jkey,jdata);
        table_->get_object(jkey,jdata);
    }
    catch(vmp::exception &x)
    {
        vmp::except_s("json::JTable::input() input jdata bad values");
    }
}

void JTable::cancel(vmp::str jkey)
{
    check_init("cancel");
    table_->del_object(jkey);
}

vmp_bool JTable::search(vmp::str jkey,json::JsonObj *jdata)
{
    check_init("search");
    vmp::except_check_pointer((void *) jdata,"json::JTable::search() null input pointer jdata");
    try
    {
        table_->get_object(jkey,jdata);
    }
    catch(vmp::exception &x)
    {
        return false;
    }
    return true;
}

}}

